/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils;

import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public abstract class JiraSprintDataUtilsCloud {
    private static final Logger log = LoggerFactory.getLogger(JiraSprintDataUtilsCloud.class);
    private static final Map<String, String> GET_SPRINTS_PARAMS;
    private static final String SPRINT_CUSTOM_SCHEMA = "com.pyxis.greenhopper.jira:gh-sprint";

    public static List retrieveActiveSprintsWithProjects(JiraConnector jiraConnector, Long boardId) {
        List<Map> sprints = JiraSprintDataUtils.getSprints(jiraConnector, boardId, GET_SPRINTS_PARAMS);
        List<Map> sprintsWithProject = JiraSprintDataUtilsCloud.setSprintsProjects(jiraConnector, boardId, sprints);
        return sprintsWithProject;
    }

    public static List getSprintsWithProjects(JiraConnector jiraConnector, Long boardId, Map<String, String> sprintParams) {
        List<Map> sprints = JiraSprintDataUtils.getSprints(jiraConnector, boardId, sprintParams);
        List<Map> sprintsWithProject = JiraSprintDataUtilsCloud.setSprintsProjects(jiraConnector, boardId, sprints);
        return sprintsWithProject;
    }

    private static List<Map> setSprintsProjects(JiraConnector jiraConnector, Long boardId, List<Map> sprints) {
        List<Map> projects = JiraSprintDataUtilsCloud.getProjectsByBoard(jiraConnector, boardId);
        List<Map> sprintsWithProject = sprints.stream().map(sprint -> {
            sprint.put("projects", projects);
            return sprint;
        }).collect(Collectors.toList());
        return sprintsWithProject;
    }

    private static List<Map> getProjectsByBoard(JiraConnector jiraConnector, Long boardId) {
        ResponseEntity<List> projectsResponse = jiraConnector.getBoardProjects(boardId);
        return projectsResponse.getStatusCode().value() >= 400 ? null : (List)projectsResponse.getBody();
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", "active");
        GET_SPRINTS_PARAMS = Collections.unmodifiableMap(map);
    }
}

