/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.BoardsAndSprints;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.ConfigWithGenericFilter;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.VelocityChartConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.AgileGadgetReponseData;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDataUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtilsSrv;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.TimePeriodOption;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.TimePeriodUtil;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class VelocityChart
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(VelocityChart.class);
    private static final List<String> DEFAULT_FIELDS = Arrays.asList("status", "id", "created", "issuetype");
    static final String SPRINT_FIELD_OBSERVED_DATE = "completeDate";
    @Inject
    private JiraSprintDataUtilsSrv jiraSprintUtils;

    private Long getDateValue(Map sprint) {
        String date = (String)sprint.get(SPRINT_FIELD_OBSERVED_DATE);
        return date == null ? Long.MAX_VALUE : DateTime.parse((String)date).getMillis();
    }

    protected List<Map> getSprintsByNElements(int lastNElements, List<Map> allSprints) {
        return allSprints.stream().sorted((s1, s2) -> this.getDateValue((Map)s1).compareTo(this.getDateValue((Map)s2))).skip(Math.max(0, allSprints.size() - lastNElements)).collect(Collectors.toList());
    }

    protected List<Map> getSprintsByTimePeriod(int timePeriod, List<Map> allSprints) {
        return allSprints.stream().filter(sprint -> {
            Object rawDate = sprint.get(SPRINT_FIELD_OBSERVED_DATE);
            return rawDate != null && TimePeriodUtil.matchOptionTimePeriod(TimePeriodOption.getById(timePeriod), (String)rawDate);
        }).collect(Collectors.toList());
    }

    protected List<Map> filterSprints(ConfigWithGenericFilter config, List<Map> allSprints) {
        List<Map> tmpSprints = this.jiraSprintUtils.filterSprintsByState(allSprints, config.getSprintFilter());
        return config.getByTime() != false ? this.getSprintsByTimePeriod(config.getTimePeriod(), tmpSprints) : this.getSprintsByNElements(config.getnElements(), tmpSprints);
    }

    protected List<Map> getSprintIssues(VelocityChartConfig config, List<String> extraParams, List<Map> sprints, String filterId) {
        if (sprints.isEmpty()) {
            return Collections.emptyList();
        }
        String sprintClause = !extraParams.isEmpty() ? extraParams.get(0) : "Sprint";
        String sprintFieldKey = extraParams.size() > 1 ? extraParams.get(1) : "sprint";
        LinkedList<String> extraFields = new LinkedList<String>(DEFAULT_FIELDS);
        extraFields.add(sprintFieldKey);
        List<Map> issues = this.jiraSprintUtils.getSprintIssues(this.jiraConnector, sprints, config.getMetric(), extraFields, sprintClause, sprintFieldKey, filterId);
        return issues;
    }

    AgileGadgetReponseData getDataBasedOnBoards(VelocityChartConfig config, List<String> extraParams) {
        List boardsAndSprints = config.getAllBoards().parallelStream().map(boardId -> {
            try {
                ResponseEntity<String> response = this.jiraConnector.getBoardConfiguration((Long)boardId);
                Map boardConfig = this.checkStatusAndParse(response, Map.class);
                List<Map> allSprints = this.jiraSprintUtils.getSprintsWithProjects(this.jiraConnector, (Long)boardId, Collections.emptyMap());
                List<Map> filteredSprints = !(config instanceof ConfigWithGenericFilter) ? allSprints : this.filterSprints(config, allSprints);
                return new BoardsAndSprints(boardConfig, filteredSprints);
            }
            catch (Exception e) {
                log.error("Problem getting the data of the boardId: " + boardId, (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List<Map> issues = boardsAndSprints.stream().map(boardSprints -> {
            String filterId = (String)((Map)boardSprints.getBoard().get("filter")).get("id");
            return this.getSprintIssues(config, extraParams, boardSprints.getSprints(), filterId);
        }).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        List<Map> sprints = boardsAndSprints.stream().map(BoardsAndSprints::getSprints).flatMap(Collection::stream).collect(Collectors.toList());
        return new AgileGadgetReponseData(JiraDataUtils.removeDuplicate(sprints), JiraDataUtils.removeDuplicate(issues));
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        VelocityChartConfig config = GadgetRequesterUtils.getConfig(gadget, VelocityChartConfig.class);
        return this.getDataBasedOnBoards(config, extraParams);
    }
}

