/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.util.JSMDataUtil2;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.util.SLAAccomplishmentConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.ContextUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDataUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.ListUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class SLAByProject
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(SLAByProject.class);
    private static final List<String> CREATED_FIELDS = Arrays.asList("project", "resolution", "issuetype", "status");
    private static final List<String> DEFAULT_RESOLVED_FIELDS = Arrays.asList("project", "status");

    protected List getFields() throws Exception {
        String rawReponse = (String)this.jiraConnector.getFields().getBody();
        ObjectMapper mapper = new ObjectMapper();
        return (List)mapper.readValue(rawReponse, (TypeReference)new TypeReference<List<Field>>(){});
    }

    protected List<Field> getMatchingFields(SLAAccomplishmentConfig config) throws Exception {
        List fields = this.getFields();
        String fieldId = config.getSlaField().get(0);
        return JiraDataUtils.getFieldsWithSameName(fieldId, fields);
    }

    String getProjectJQL(List<Map> projects) {
        return String.format("project IN (%s)", projects.stream().map(aProject -> String.format("'%s'", aProject.get("key"))).collect(Collectors.joining(", ")));
    }

    protected List<Map> getProjects(SLAAccomplishmentConfig config) {
        ResponseEntity<List> response;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("typeKey", "service_desk");
        params.put("action", "browse");
        List<String> prjKeys = config.getProjects();
        if (!prjKeys.isEmpty()) {
            params.put("keys", prjKeys);
        }
        if ((response = this.jiraConnector.getProjects(params)).getStatusCode().value() >= 400) {
            throw new BadRequestToSourceException(response);
        }
        List allProjects = (List)response.getBody();
        List<Map> projects = allProjects.stream().filter(aProject -> "service_desk".equals(aProject.get("projectTypeKey"))).collect(Collectors.toList());
        return projects;
    }

    protected List getNewIssues(String dateFrom, String projectsJql, List<Field> matchingFields) {
        String createdJql = String.format("created >= '%s' AND %s", dateFrom, projectsJql);
        List<String> fields = JSMDataUtil2.getKeysOrIds(matchingFields);
        return this.execJQLwithFilterFields(createdJql, ListUtils.union(fields, CREATED_FIELDS), null, null, null, null);
    }

    protected List getIssues(String dateFrom, String projectAndFieldsJQL, List<Field> matchingFields) {
        String resolutionQuery = JSMDataUtil2.getResolutionQuery(dateFrom, true);
        String resolvedJql = String.format("%s AND %s", resolutionQuery, projectAndFieldsJQL);
        List<String> fields = JSMDataUtil2.getKeysOrIds(matchingFields);
        return this.execJQLwithFilterFields(resolvedJql, ListUtils.union(fields, DEFAULT_RESOLVED_FIELDS), null, null, null, null);
    }

    protected List getSlaIssues(String dateFrom, String projectsAndFieldsJql, List<Field> matchingFields) {
        String updatedJql = String.format("updated >= '%s' AND %s", dateFrom, projectsAndFieldsJql);
        List<String> fields = JSMDataUtil2.getKeysOrIds(matchingFields);
        return this.execJQLwithFilterFields(updatedJql, ListUtils.union(fields, CREATED_FIELDS), null, null, null, null);
    }

    protected List<Map> getProjectsFilteredByContext(List<Map> projects, List newIssues, List issues, List slaIssues) {
        if (ContextUtils.hasContextFilterJql(this.context)) {
            return ContextUtils.removeEmptyProjects(projects, ListUtils.union((List)ListUtils.union((List)newIssues, (List)issues), (List)slaIssues));
        }
        return projects;
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        SLAAccomplishmentConfig config = GadgetRequesterUtils.getConfig(gadget, SLAAccomplishmentConfig.class);
        try {
            List newIssues = Collections.emptyList();
            List issues = Collections.emptyList();
            List slaIssues = Collections.emptyList();
            List<Map> projects = this.getProjects(config);
            if (!projects.isEmpty()) {
                String projectJql = this.getProjectJQL(projects);
                List<Field> matchingFields = this.getMatchingFields(config);
                String dateFrom = JSMDataUtil2.getDateAsString(config.getTimeRange());
                String matchingFieldsSubQuery = JSMDataUtil2.getMatchingFieldsSubQuery(matchingFields);
                String projectAndFieldsJQL = String.format("%s AND (%s)", projectJql, matchingFieldsSubQuery);
                newIssues = this.getNewIssues(dateFrom, projectJql, matchingFields);
                issues = this.getIssues(dateFrom, projectAndFieldsJQL, matchingFields);
                slaIssues = this.getSlaIssues(dateFrom, projectAndFieldsJQL, matchingFields);
            }
            HashMap<String, List<Map>> data = new HashMap<String, List<Map>>();
            data.put("newIssues", newIssues);
            data.put("issues", issues);
            data.put("slaIssues", slaIssues);
            data.put("projects", this.getProjectsFilteredByContext(projects, newIssues, issues, slaIssues));
            return data;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems getting data", e);
        }
    }
}

