/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.JSMMultiproject;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.util.CustomerSatisfactionConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.util.JSMDataUtil2;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerSatisfaction
extends JSMMultiproject {
    private static final Logger log = LoggerFactory.getLogger(CustomerSatisfaction.class);

    protected List getIssues(String dateFrom, String queuesJql, String feedbackFieldName, List<String> fieldNames) {
        String jql = String.format("%s != NULL AND updatedDate >= '%s' AND (%s)", feedbackFieldName, dateFrom, queuesJql);
        return this.execJQLwithFilterFields(jql, fieldNames, null, null, null, null);
    }

    protected List getPreviousIssues(String dateFrom, String dateFromPrevious, String queuesJql, String feedbackFieldName, List<String> fieldNames) {
        String jql = String.format("%s != NULL AND updatedDate < '%s' AND updatedDate >= '%s' AND (%s)", feedbackFieldName, dateFrom, dateFromPrevious, queuesJql);
        return this.execJQLwithFilterFields(jql, fieldNames, null, null, null, null);
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        CustomerSatisfactionConfig config = GadgetRequesterUtils.getConfig(gadget, CustomerSatisfactionConfig.class);
        try {
            if (config.getProjectsQueues() == null) {
                config.setProjectQueue(config.getProject(), config.getQueue());
            }
            List<Map> queues = this.getQueues(config);
            String queuesJql = queues.stream().map(queueJql -> queueJql.get("jql").toString().split("ORDER BY")[0]).collect(Collectors.joining(" OR "));
            String dateFrom = JSMDataUtil2.getDateAsString(config.getTimeRange());
            String feedbackFieldName = config.getFeedbackField().get(1);
            List issues = this.getIssues(dateFrom, queuesJql, feedbackFieldName, Arrays.asList(config.getFeedbackField().get(0), config.getFeedbackDateField().get(0)));
            String dateFromPrevious = JSMDataUtil2.getPreviousDateAsString(config.getTimeRange(), 2);
            List previousIssues = this.getPreviousIssues(dateFrom, dateFromPrevious, queuesJql, feedbackFieldName, Arrays.asList(config.getFeedbackField().get(0), config.getFeedbackDateField().get(0)));
            HashMap<String, List<Map>> data = new HashMap<String, List<Map>>();
            data.put("issues", issues);
            data.put("previousIssues", previousIssues);
            data.put("queues", queues);
            return data;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems getting data", e);
        }
    }
}

