/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.confluenceServer.functions;

import com.roninpixels.dashboardhub.connectors.impl.confluenceServer.ConfluenceRestConnector;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class IsValidFunc {
    private static final Logger log = LoggerFactory.getLogger(IsValidFunc.class);
    private final ConfluenceRestConnector confConnector;
    private final ServerConnector connector;

    public IsValidFunc(ConfluenceRestConnector confConnector, ServerConnector connector) {
        this.confConnector = confConnector;
        this.connector = connector;
    }

    public boolean isValid() {
        try {
            ResponseEntity<String> response = this.confConnector.serverInfo();
            log.debug("SERVER INFO");
            log.debug("-----------status code", (Object)response.getStatusCode());
            log.debug("------------------body", response.getBody());
            if (response.getStatusCode().value() >= 400) {
                return false;
            }
            ObjectMapper mapper = new ObjectMapper();
            Map data = (Map)mapper.readValue((String)response.getBody(), Map.class);
            log.debug("------------------buildNumber", data.get("buildNumber"));
            int buildNumber = (Integer)data.get("buildNumber");
            return buildNumber >= 7901;
        }
        catch (Exception e) {
            log.error("Problems getting server info. URL base: " + this.confConnector.getURL(), (Throwable)e);
            return false;
        }
    }
}

