/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.confluenceServer.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class GetSpacesFunc {
    private static final Logger log = LoggerFactory.getLogger(GetSpacesFunc.class);
    private final ServerConnector connector;

    public GetSpacesFunc(ServerConnector connector) {
        this.connector = connector;
    }

    public ResponseEntity<List> getSpaces(Map params, Map options) {
        boolean all = options != null ? options.getOrDefault("all", false) : false;
        HashMap<String, Integer> mParams = params != null ? new HashMap<String, Integer>(params) : new HashMap();
        mParams.putIfAbsent("start", 0);
        mParams.put("limit", all ? Integer.valueOf(1000) : mParams.getOrDefault("limit", 1000));
        int maxSpaces = Math.min((Integer)mParams.get("limit"), 1000);
        boolean moreSpaces = true;
        LinkedList result = new LinkedList();
        while (moreSpaces) {
            ResponseEntity<Map> responseEntity = this.connector.executeRequest("/rest/api/space", mParams, Map.class);
            if (responseEntity.getStatusCode().value() >= 400) {
                return new ResponseEntity(responseEntity.getStatusCode());
            }
            Map response = (Map)responseEntity.getBody();
            List spaces = (List)response.get("results");
            int limit = (Integer)response.get("limit");
            int next = (Integer)response.get("start") + limit;
            result.addAll(spaces);
            moreSpaces = spaces.size() >= limit && result.size() < maxSpaces;
            if (!moreSpaces) continue;
            mParams.put("start", next);
            mParams.put("limit", limit);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }
}

