/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions;

import com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.functions.BitbucketDatacenterBaseFunc;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class GetPrsFunc
extends BitbucketDatacenterBaseFunc {
    private static final Logger log = LoggerFactory.getLogger(GetPrsFunc.class);
    public static final String PATH_PATTERN = "/rest/api/1.0/projects/%s/repos/%s/pull-requests";

    public GetPrsFunc(ServerConnector serverConnector) {
        super(serverConnector);
    }

    public ResponseEntity<List> exec(String projectKey, String repoSlug) {
        String path = String.format(PATH_PATTERN, projectKey, repoSlug);
        List prs = this.getData(path, Collections.emptyMap(), 1000, true);
        prs.stream().forEach(pr -> pr.put("repo_slug", repoSlug));
        return new ResponseEntity((Object)prs, HttpStatus.OK);
    }
}

