/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.proxy;

import com.roninpixels.dashboardhub.controllers.ImageController;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;

@Path(value="/proxy/image")
public class ImageProxyEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ImageProxyEndpoint.class);
    @Autowired
    private ImageController imageController;

    private static final String getExpirationTime() {
        return DateTime.now().plusYears(1).toDateTime(DateTimeZone.UTC).toString();
    }

    @GET
    @Produces(value={"application/octet-stream"})
    public Response get(@NotNull @HeaderParam(value="dsextraconfig") String dsextraconfig, @Context UriInfo ui) {
        try {
            MultivaluedMap params = ui.getQueryParameters();
            String route = (String)((LinkedList)params.get((Object)"route")).get(0);
            Map dsExtraConfigMap = (Map)new ObjectMapper().readValue(new String(Base64.getDecoder().decode(dsextraconfig)), HashMap.class);
            ResponseEntity<InputStream> imageResponseEntity = this.imageController.getImage((String)dsExtraConfigMap.get("datasourceId"), route);
            return Response.status((int)imageResponseEntity.getStatusCode().value()).entity(imageResponseEntity.getBody()).header("Content-Type", (Object)imageResponseEntity.getHeaders().getContentType()).build();
        }
        catch (Exception e) {
            return Response.status((int)404).build();
        }
    }
}

