/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.jira.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtils;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.web.rest.jira.api.GenericJiraEndpoint;
import com.roninpixels.dashboardhub.web.rest.jira.api.JQLRequest;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

@Path(value="/jira/v1/jql")
public class JQLEndpoint {
    private static final Logger log = LoggerFactory.getLogger(JQLEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;
    @Inject
    private DHUserService dhUserService;
    private ObjectMapper mapper = new ObjectMapper();

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response jql(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, JQLRequest jqlProxyRequest) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            List issues = jira.execJQL(jqlProxyRequest.getJql(), jqlProxyRequest.getFields(), jqlProxyRequest.getExpand(), jqlProxyRequest.getProperties(), jqlProxyRequest.getExtraOpts(), this.dhUserService.getLoggedInUserKey());
            if (!jira.isCloud()) {
                JiraSprintDataUtils.fixSprintField(issues, (List)this.mapper.readValue((String)jira.getFields().getBody(), (TypeReference)new TypeReference<List<Field>>(){}));
            }
            ObjectMapper mapper = new ObjectMapper();
            String responseBody = mapper.writeValueAsString((Object)issues);
            ResponseEntity response = new ResponseEntity((Object)responseBody, HttpStatus.ACCEPTED);
            return GenericJiraEndpoint.generateResponse(response);
        }
        catch (Exception e) {
            log.error("Problems with a jql query (by proxy)", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

