/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils;

import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtilsCloud;
import java.util.List;
import java.util.Map;
import javax.inject.Named;

@Named
public class JiraSprintDataUtilsSrv {
    public List<Map> getSprintIssues(JiraConnector jiraConnector, List<Map> sprints, List<String> metric, List<String> extraFields, String sprintClause, String sprintFieldKey, String filterId) {
        List issues = JiraSprintDataUtils.getSprintIssues(jiraConnector, sprints, metric, extraFields, sprintClause, filterId);
        if (!jiraConnector.isCloud()) {
            this.fixSprintField(issues, sprints, sprintFieldKey);
        }
        return issues;
    }

    public List<Map> getSprints(JiraConnector jiraConnector, Long boardId, Map<Object, Object> params) {
        return JiraSprintDataUtils.getSprints(jiraConnector, boardId, params);
    }

    public List<Map> getSprintsWithProjects(JiraConnector jiraConnector, Long boardId, Map params) {
        return jiraConnector.isCloud() ? JiraSprintDataUtilsCloud.getSprintsWithProjects(jiraConnector, boardId, params) : JiraSprintDataUtils.getSprintsWithProjects(jiraConnector, boardId, params);
    }

    public void fixSprintField(List<Map> issues, List<Map> sprints, String sprintFieldKey) {
        JiraSprintDataUtils.fixSprintField(issues, sprints, sprintFieldKey);
    }

    public List<Map> filterSprintsByState(List<Map> sprints, List<String> allowedStates) {
        return JiraSprintDataUtils.filterSprintsByState(sprints, allowedStates);
    }
}

