/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.SprintBurndownConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprintHealth
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(SprintHealth.class);
    private static final List<String> DEFAULT_FIELDS = Arrays.asList("status", "id", "created", "issuelinks");

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        SprintBurndownConfig config = GadgetRequesterUtils.getConfig(gadget, SprintBurndownConfig.class);
        String sprintClause = extraParams.isEmpty() ? "Sprint" : extraParams.get(0);
        List sprints = JiraSprintDataUtils.retrieveActiveSprintsWithProjects(this.jiraConnector, config.getBoard());
        Map activeSprint = JiraSprintDataUtils.getActiveSprint(sprints);
        if (activeSprint == null) {
            return JiraSprintDataUtils.createResponse(null, null);
        }
        LinkedList<String> fields = new LinkedList<String>(DEFAULT_FIELDS);
        if (extraParams.get(1) != null) {
            fields.add(extraParams.get(1));
        }
        List issues = JiraSprintDataUtils.getSprintIssues(this.jiraConnector, activeSprint, config.getMetric(), fields, sprintClause);
        return JiraSprintDataUtils.createResponse(sprints, issues);
    }
}

