/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.jira.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.web.rest.jira.api.AreScrumRequestBody;
import com.roninpixels.dashboardhub.web.rest.jira.api.GenericJiraEndpoint;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/jira/v1/boards")
public class BoardsEndpoint {
    private static final Logger log = LoggerFactory.getLogger(BoardsEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;
    @Inject
    private DHUserService dhUserService;

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response get(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @Context UriInfo ui) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            MultivaluedMap params = ui.getQueryParameters();
            return GenericJiraEndpoint.generateResponse(jira.getBoards((Map<String, ?>)params));
        }
        catch (Exception e) {
            log.error("Problems getting boards", (Throwable)e);
            return Response.status((int)400).build();
        }
    }

    @GET
    @AnonymousAllowed
    @Path(value="/{boardId}/configuration")
    @Produces(value={"application/json"})
    public Response getBoardConfiguration(@NotNull @PathParam(value="boardId") Long boardId, @NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            return GenericJiraEndpoint.generateResponse(jira.getBoardConfiguration(boardId));
        }
        catch (Exception e) {
            log.error("Problem getting configuration for jira-board -> " + boardId, (Throwable)e);
            return Response.status((int)400).build();
        }
    }

    @GET
    @AnonymousAllowed
    @Path(value="/{boardId}/sprints")
    @Produces(value={"application/json"})
    public Response getBoardSprints(@NotNull @PathParam(value="boardId") Long boardId, @NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            String userKey = this.dhUserService.getLoggedInUserKey();
            return GenericJiraEndpoint.generateResponse(jira.getBoardsSprints(boardId, null, userKey));
        }
        catch (Exception e) {
            log.error("Problem getting sprints for jira-board -> " + boardId, (Throwable)e);
            return Response.status((int)400).build();
        }
    }

    @POST
    @AnonymousAllowed
    @Path(value="/areScrum")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response areScrums(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, AreScrumRequestBody areScrum) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            String userKey = this.dhUserService.getLoggedInUserKey();
            List areArray = areScrum.getBoards().parallelStream().map(boardId -> {
                try {
                    ResponseEntity<List> reponse = jira.getBoardsSprints((Long)boardId, null, userKey);
                    return reponse.getStatusCode().value() < 400;
                }
                catch (Exception e) {
                    return false;
                }
            }).collect(Collectors.toList());
            return Response.ok(areArray).build();
        }
        catch (Exception e) {
            String boards = areScrum.getBoards() == null ? null : areScrum.getBoards().toString();
            log.error("Problem checking boards: " + boards, (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

