/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.utils.crypto;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class FrontendCryptoTool {
    private static final String ALGORITHM = "AES";
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private String secret;

    public FrontendCryptoTool(String secret) {
        this.secret = secret;
    }

    public String decrypt(String encryptedData) throws GeneralSecurityException {
        byte[] cipherData = Base64.getDecoder().decode(encryptedData);
        byte[] saltData = Arrays.copyOfRange(cipherData, 8, 16);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[][] keyAndIV = FrontendCryptoTool.GenerateKeyAndIV(32, 16, 1, saltData, this.secret.getBytes(ENCODING), md5);
        SecretKeySpec key = new SecretKeySpec(keyAndIV[0], ALGORITHM);
        IvParameterSpec iv = new IvParameterSpec(keyAndIV[1]);
        byte[] encrypted = Arrays.copyOfRange(cipherData, 16, cipherData.length);
        Cipher aesCBC = Cipher.getInstance("AES/CBC/PKCS5Padding");
        aesCBC.init(2, (Key)key, iv);
        byte[] decryptedData = aesCBC.doFinal(encrypted);
        String decryptedText = new String(decryptedData, StandardCharsets.UTF_8);
        return decryptedText;
    }

    public static byte[][] GenerateKeyAndIV(int keyLength, int ivLength, int iterations, byte[] salt, byte[] password, MessageDigest md) {
        int digestLength = md.getDigestLength();
        int requiredLength = (keyLength + ivLength + digestLength - 1) / digestLength * digestLength;
        byte[] generatedData = new byte[requiredLength];
        try {
            md.reset();
            for (int generatedLength = 0; generatedLength < keyLength + ivLength; generatedLength += digestLength) {
                if (generatedLength > 0) {
                    md.update(generatedData, generatedLength - digestLength, digestLength);
                }
                md.update(password);
                if (salt != null) {
                    md.update(salt, 0, 8);
                }
                md.digest(generatedData, generatedLength, digestLength);
                for (int i = 1; i < iterations; ++i) {
                    md.update(generatedData, generatedLength, digestLength);
                    md.digest(generatedData, generatedLength, digestLength);
                }
            }
            byte[][] result = new byte[2][];
            result[0] = Arrays.copyOfRange(generatedData, 0, keyLength);
            if (ivLength > 0) {
                result[1] = Arrays.copyOfRange(generatedData, keyLength, keyLength + ivLength);
            }
            byte[][] byArrayArray = result;
            return byArrayArray;
        }
        catch (DigestException e) {
            throw new RuntimeException(e);
        }
        finally {
            Arrays.fill(generatedData, (byte)0);
        }
    }
}

