/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JqlUtils;
import com.roninpixels.dashboardhub.utils.filter.FilterUtils;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.collections.ListUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

public abstract class JiraBaseGadgetRequester
implements GadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(JiraBaseGadgetRequester.class);
    @Inject
    private ConnectorsProvider provider;
    protected JiraConnector jiraConnector;
    protected Map context;

    @Override
    public void init(DatasourceModel datasource, Map context) {
        this.jiraConnector = (JiraConnector)this.provider.getConnector(datasource);
        if (this.jiraConnector == null) {
            throw new IllegalArgumentException("Datasource is not valid for gadget requester: " + this.getClass().getAnnotation(Component.class));
        }
        this.context = context;
    }

    protected void checkStatus(ResponseEntity<?> response) throws BadRequestToSourceException {
        if (response.getStatusCode().value() >= 400) {
            throw new BadRequestToSourceException(response);
        }
    }

    protected <T> T checkStatusAndParse(ResponseEntity<String> response, Class<T> clazz) throws Exception {
        this.checkStatus(response);
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.readValue((String)response.getBody(), clazz);
    }

    protected List execJQLwithFilterFields(String jql, List<String> fields, List<String> expand, List<String> properties, Map<String, Object> extraOpts, String userKey) {
        String contentFilteringJQL = JqlUtils.appendContextFilterToJql(jql, this.context);
        return this.jiraConnector.execJQL(contentFilteringJQL, ListUtils.union(fields, FilterUtils.USER_FILTER_FIELDS), expand, properties, extraOpts, userKey);
    }
}

