/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.servlet;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.roninpixels.dashboardhub.config.action.DHAction;
import com.roninpixels.dashboardhub.config.action.DHShowAction;
import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DashboardHubServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DashboardHubServlet.class);
    protected static final String RESOURCE = "resources";
    @Inject
    @ComponentImport
    private TemplateRenderer templateRenderer;
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private Provider<DHShowAction> actionsProvider;
    private String resources;

    public void init() {
        this.resources = this.getServletConfig().getInitParameter(RESOURCE);
    }

    protected abstract Map<String, Object> getInitialContext();

    protected abstract String getTemplatePath();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> context = this.getInitialContext();
        context.put("resp", resp);
        context.put("scope", Collections.singletonList(this.resources));
        DHAction action = this.getAction(req);
        context.put("dh", action);
        context.put("action", action);
        resp.setHeader("Content-Type", "text/html");
        this.templateRenderer.render(this.getTemplatePath(), context, (Writer)resp.getWriter());
    }

    protected DHAction getAction(HttpServletRequest req) {
        TokenContentModel tokenContent = this.getTokenData(req, "ac.boardToken");
        DHShowAction action = (DHShowAction)this.actionsProvider.get();
        action.setToken(tokenContent);
        return action;
    }

    protected TokenContentModel getTokenData(HttpServletRequest request, String tokenParamName) {
        String token = request.getParameter(tokenParamName);
        if (token != null) {
            try {
                return this.tokenGenerator.getTokenContent(token);
            }
            catch (Exception e) {
                log.error("Problems with a token -> " + token, (Throwable)e);
            }
        }
        return null;
    }
}

