/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.dashboardHub.boards;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.controllers.BoardsControllerV2;
import com.roninpixels.dashboardhub.exceptions.BadRequestException;
import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import com.roninpixels.dashboardhub.web.rest.MessagesUtil;
import com.roninpixels.dashboardhub.web.rest.dashboardHub.boards.UnlockMessageModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/board/unlock")
public class UnlockBoardEndpoint {
    private static final Logger log = LoggerFactory.getLogger(UnlockBoardEndpoint.class);
    private static final int MAX_TRIALS = 3;
    private static final int MAX_AGE = 3600000;
    @Inject
    private BoardsControllerV2 boardsController;
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private Crypto crypto;

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response unlock(@NotNull UnlockMessageModel message, @Context HttpServletRequest request) {
        String id = message.getBoardId();
        try {
            RequestHandler handler = new RequestHandler(message, request.getCookies());
            handler.validate();
            TokenContentModel tokenContent = this.tokenGenerator.getTokenContent(message.getBoardToken());
            if (tokenContent.getBoardId() == null || !id.equals(tokenContent.getBoardId())) {
                throw new BadRequestException(404, "BOARDS_DO_NOT_MATCH");
            }
            BoardModel board = this.boardsController.getUserBoard(tokenContent.getUsserAccountId(), id, tokenContent.getGlobal());
            if (board == null) {
                throw new BadRequestException(404, "INVALID_BOARD");
            }
            boolean isValid = this.crypto.isHashValid(board.getSharing().getPassword(), message.getPassword());
            if (!isValid) {
                return this.createBadCredentialsResponse(handler);
            }
            return this.createResponseWithBoard(handler, board);
        }
        catch (BadRequestException bre) {
            return MessagesUtil.generateErrorResponse(bre.getStatusCode(), bre.getMessage());
        }
        catch (Exception e) {
            log.error("Problems getting a protected board with id -> " + id, (Throwable)e);
            return MessagesUtil.generateErrorResponse(400, "INVALID_BOARD");
        }
    }

    private Response createResponseWithBoard(RequestHandler handler, BoardModel board) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRAP_ROOT_VALUE});
        return Response.ok((Object)mapper.writeValueAsString((Object)board)).cookie(new NewCookie[]{handler.getNewCookieForTrials(0), handler.getNewCookieForExpirationTime(0L)}).build();
    }

    private Response createBadCredentialsResponse(RequestHandler handler) {
        int newTrialsValue = handler.getTrials() + 1;
        long newExpirationAt = DateTime.now().plusHours(1).getMillis();
        HashMap<String, Object> entity = new HashMap<String, Object>();
        entity.put("error", "INVALID_CREDENTIALS");
        entity.put("remaining", 3 - newTrialsValue);
        entity.put("t", newTrialsValue);
        entity.put("f", newExpirationAt);
        return Response.status((int)403).cookie(new NewCookie[]{handler.getNewCookieForTrials(newTrialsValue), handler.getNewCookieForExpirationTime(newExpirationAt)}).entity(entity).build();
    }

    class RequestHandler {
        private UnlockMessageModel message;
        private Cookie[] cookies;
        private final String trialsCookieName;
        private final String expirationAtCookieName;

        RequestHandler(UnlockMessageModel message, Cookie[] cookies) {
            this.message = message;
            this.cookies = cookies == null ? new Cookie[]{} : cookies;
            String baseName = String.format("board-trials-%s", message.getBoardId());
            this.trialsCookieName = String.format("%s-t", baseName);
            this.expirationAtCookieName = String.format("%s-d", baseName);
        }

        void validate() throws BadRequestException {
            this.validateInput();
            this.validateCookie();
        }

        Integer getTrials() {
            Cookie cookie = this.getCookie(this.trialsCookieName);
            return cookie != null ? Integer.parseInt(cookie.getValue()) : 0;
        }

        NewCookie getNewCookieForTrials(int newValue) {
            Cookie cookie = this.getCookie(this.trialsCookieName);
            return this.getNewCookie(cookie, this.trialsCookieName, "" + newValue);
        }

        NewCookie getNewCookieForExpirationTime(long newValue) {
            Cookie cookie = this.getCookie(this.expirationAtCookieName);
            return this.getNewCookie(cookie, this.expirationAtCookieName, "" + newValue);
        }

        private void validateInput() throws BadRequestException {
            String id = this.message.getBoardId();
            if (id == null || this.message.getPassword() == null || this.message.getBoardToken() == null) {
                throw new BadRequestException(400, "INVALID_PARAMS");
            }
        }

        private void validateCookie() throws BadRequestException {
            Long expiresAt = this.getExpirationTime();
            Integer trials = this.getTrials();
            if (trials != null && trials >= 3) {
                throw new BadRequestException(403, "MAX_TRIALS_REACHED");
            }
        }

        private Cookie getCookie(String name) {
            return Arrays.stream(this.cookies).filter(cookie -> cookie.getName().equals(name)).findAny().orElse(null);
        }

        private Long getExpirationTime() {
            Cookie cookie = this.getCookie(this.expirationAtCookieName);
            return cookie != null ? Long.valueOf(Long.parseLong(cookie.getValue())) : null;
        }

        private NewCookie getNewCookie(Cookie cookie, String name, String newValue) {
            String path = cookie == null ? null : cookie.getPath();
            String domain = cookie == null ? null : cookie.getDomain();
            String comment = cookie == null ? null : cookie.getComment();
            int version = cookie == null ? 1 : cookie.getVersion() + 1;
            return new NewCookie(name, newValue, path, domain, version, comment, 3600000, false);
        }
    }
}

