/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.SprintBurndownConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDataUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprintBurndown
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(SprintBurndown.class);
    private static final List<String> DEFAULT_FIELDS = Arrays.asList("status", "id", "created", "issuetype");

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        SprintBurndownConfig config = GadgetRequesterUtils.getConfig(gadget, SprintBurndownConfig.class);
        String sprintClause = !extraParams.isEmpty() ? extraParams.get(0) : "Sprint";
        List sprints = JiraSprintDataUtils.retrieveActiveSprintsWithProjects(this.jiraConnector, config.getBoard());
        Map activeSprint = null;
        if (sprints != null && (activeSprint = JiraDataUtils.getActiveSprint(config.getBoard(), sprints)) == null) {
            activeSprint = sprints.stream().filter(sprint -> "active".equals(sprint.get("state"))).findFirst().orElse(null);
        }
        if (activeSprint == null) {
            return JiraSprintDataUtils.createResponse(null, null);
        }
        List issues = JiraSprintDataUtils.getSprintIssues(this.jiraConnector, activeSprint, config.getMetric(), DEFAULT_FIELDS, sprintClause);
        return JiraSprintDataUtils.createResponse(sprints, issues);
    }
}

