/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.VelocityChartConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtilsCloud;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtilsSrv;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.TimePeriodOption;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.TimePeriodUtil;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityChart
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(VelocityChart.class);
    private static final List<String> DEFAULT_FIELDS = Arrays.asList("status", "id", "created", "issuetype");
    static final String SPRINT_FIELD_OBSERVED_DATE = "completeDate";
    @Inject
    private JiraSprintDataUtilsSrv jiraSprintUtils;

    private Long getDateValue(Map sprint) {
        String date = (String)sprint.get(SPRINT_FIELD_OBSERVED_DATE);
        return date == null ? Long.MAX_VALUE : DateTime.parse((String)date).getMillis();
    }

    protected List<Map> getSprintsByNElements(int lastNElements, List<Map> allSprints) {
        return allSprints.stream().sorted((s1, s2) -> this.getDateValue((Map)s1).compareTo(this.getDateValue((Map)s2))).skip(Math.max(0, allSprints.size() - lastNElements)).collect(Collectors.toList());
    }

    protected List<Map> getSprintsByTimePeriod(int timePeriod, List<Map> allSprints) {
        return allSprints.stream().filter(sprint -> {
            Object rawDate = sprint.get(SPRINT_FIELD_OBSERVED_DATE);
            return rawDate != null && TimePeriodUtil.matchOptionTimePeriod(TimePeriodOption.getById(timePeriod), (String)rawDate);
        }).collect(Collectors.toList());
    }

    protected List<Map> filterSprints(VelocityChartConfig config, List<Map> allSprints) {
        List<Map> tmpSprints = this.jiraSprintUtils.filterSprintsByState(allSprints, config.getSprintFilter());
        return config.getByTime() != false ? this.getSprintsByTimePeriod(config.getTimePeriod(), tmpSprints) : this.getSprintsByNElements(config.getnElements(), tmpSprints);
    }

    protected List<Map> getSprints(VelocityChartConfig config) {
        List<Long> boardIds = config.getAllBoards();
        List sprints = boardIds.parallelStream().map(boardId -> {
            List<Map> allSprints = this.jiraSprintUtils.getSprints(this.jiraConnector, (Long)boardId, Collections.emptyMap());
            List<Map> filteredSprints = this.filterSprints(config, allSprints);
            return filteredSprints;
        }).flatMap(Collection::stream).collect(Collectors.toList());
        HashSet ids = new HashSet();
        return sprints.stream().filter(sprint -> {
            Object key = sprint.get("id");
            return ids.add(key);
        }).collect(Collectors.toList());
    }

    protected List<Map> getSprintsWithProjectsCloud(VelocityChartConfig config) {
        List<Long> boardIds = config.getAllBoards();
        List sprints = boardIds.parallelStream().map(boardId -> {
            List allSprints = JiraSprintDataUtilsCloud.getSprintsWithProjects(this.jiraConnector, boardId, Collections.emptyMap());
            List<Map> filteredSprints = this.filterSprints(config, allSprints);
            return filteredSprints;
        }).flatMap(Collection::stream).collect(Collectors.toList());
        HashSet ids = new HashSet();
        return sprints.stream().filter(sprint -> {
            Object key = sprint.get("id");
            return ids.add(key);
        }).collect(Collectors.toList());
    }

    protected List<Map> getSprintIssues(VelocityChartConfig config, List<String> extraParams, List<Map> sprints) {
        String sprintClause = !extraParams.isEmpty() ? extraParams.get(0) : "Sprint";
        String sprintFieldKey = extraParams.size() > 1 ? extraParams.get(1) : "sprint";
        LinkedList<String> extraFields = new LinkedList<String>(DEFAULT_FIELDS);
        extraFields.add(sprintFieldKey);
        List<Map> issues = this.jiraSprintUtils.getSprintIssues(this.jiraConnector, sprints, config.getMetric(), extraFields, sprintClause);
        if (!this.jiraConnector.isCloud()) {
            this.jiraSprintUtils.fixSprintField(issues, sprints, sprintFieldKey);
        }
        return issues;
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        VelocityChartConfig config = GadgetRequesterUtils.getConfig(gadget, VelocityChartConfig.class);
        List<Map> sprints = this.jiraConnector.isCloud() ? this.getSprintsWithProjectsCloud(config) : JiraSprintDataUtils.getSprintsWithProjects(this.jiraConnector, this.getSprints(config));
        List issues = sprints.isEmpty() ? Collections.emptyList() : this.getSprintIssues(config, extraParams, sprints);
        HashMap data = new HashMap();
        data.put("sprints", sprints);
        data.put("issues", issues);
        return data;
    }
}

