/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket;

import com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket.BitbucketGadgetRequesterBase;
import com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket.configBeans.GRWithReposConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class PipelinesHistory
extends BitbucketGadgetRequesterBase {
    private static final Logger log = LoggerFactory.getLogger(PipelinesHistory.class);
    private static final String PAGE_SIZE = "5";
    static final String NO_PROJECT = null;

    List<Map> getPipelines(List<String> repos) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pagelen", PAGE_SIZE);
        params.put("sort", "-created_on");
        return super.getPipelinesUtil(repos, params);
    }

    void populateWithCommits(List<Map> pipelines) {
        pipelines.parallelStream().forEach(pipeline -> {
            Map commit = this.findCommit((Map)pipeline);
            if (commit != null) {
                String slug = (String)pipeline.get("slug");
                String hash = (String)commit.get("hash");
                ResponseEntity<Map> res = this.connector.getCommit(NO_PROJECT, slug, hash);
                this.checkStatus(res);
                commit.put("data", res.getBody());
            }
        });
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        GRWithReposConfig config = GadgetRequesterUtils.getConfig(gadget, GRWithReposConfig.class);
        List<Map> pipelines = this.getPipelines(config.getRepositoriesSlugs());
        this.populateWithCommits(pipelines);
        List<Map> sortedPipelines = this.sortPipelines(pipelines);
        HashMap<String, List<Map>> data = new HashMap<String, List<Map>>();
        data.put("pipelines", sortedPipelines);
        return data;
    }
}

