/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.jira.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.web.rest.jira.api.GenericJiraEndpoint;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/jira/v1/group")
public class UserGroupEndpoint {
    private static final Logger log = LoggerFactory.getLogger(UserGroupEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @GET
    @AnonymousAllowed
    @Path(value="/{groupName}/users")
    @Produces(value={"application/json"})
    public Response getGroupUsers(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @NotNull @PathParam(value="groupName") String groupName) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            return GenericJiraEndpoint.generateResponse(jira.getGroupUsers(groupName, null, null));
        }
        catch (Exception e) {
            log.error("Problems getting the group users. Group -> " + groupName, (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

