/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.activeobjects.tx.Transactional;
import com.roninpixels.dashboardhub.controllers.BoardPermissionsController;
import com.roninpixels.dashboardhub.controllers.BoardTokenController;
import com.roninpixels.dashboardhub.controllers.BoardUserPreferencesController;
import com.roninpixels.dashboardhub.controllers.BoardsControllerV2;
import com.roninpixels.dashboardhub.controllers.GadgetsValidationController;
import com.roninpixels.dashboardhub.gadgetsValidators.GadgetValidatorException;
import com.roninpixels.dashboardhub.gadgetsValidators.ValidationResponse;
import com.roninpixels.dashboardhub.permissions.BoardAccessManager;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.store.DHBoardsRepository;
import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.BoardSharingModel;
import com.roninpixels.dashboardhub.web.models.EncryptedBoardModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class BoardsControllerV2Impl
implements BoardsControllerV2 {
    private static final Logger log = LoggerFactory.getLogger(BoardsControllerV2Impl.class);
    @Inject
    private DHUserService dhUserService;
    @Inject
    private BoardAccessManager boardAccessManager;
    @Inject
    private BoardPermissionsController boardPermissionsController;
    @Inject
    private BoardTokenController boardTokenController;
    @Inject
    private DHBoardsRepository boardsRepo;
    @Inject
    private Crypto mCrypto;
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private BoardUserPreferencesController boardUserPreferencesController;
    @Inject
    private GadgetsValidationController validationController;
    private final ObjectMapper mMapper = new ObjectMapper();

    private List<String> getBoardIds(Boolean global) throws IOException {
        if (global.booleanValue()) {
            return this.boardsRepo.getGlobalBoardsKeys();
        }
        String userKey = this.dhUserService.getLoggedInUserKey();
        return this.boardsRepo.getPrivateBoardsKeysForUser(userKey);
    }

    @Override
    public BoardModel getBoard(String id, Boolean global) {
        try {
            BoardModel board = this.getBoard(id);
            return board == null || global != board.getGlobal() ? null : board;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BoardModel getBoard(String id) {
        EncryptedBoardModel encryptedBoard = this.boardsRepo.getBoard(id);
        if (encryptedBoard == null) {
            return null;
        }
        return this.recoverBoard(encryptedBoard);
    }

    @Override
    public List getAllBoards(Boolean global, Boolean expand) throws Exception {
        List<EncryptedBoardModel> encrypedBoards;
        if (!expand.booleanValue()) {
            return this.getBoardIds(global);
        }
        if (global.booleanValue()) {
            encrypedBoards = this.boardsRepo.getAllBoards();
        } else {
            String userKey = this.dhUserService.getLoggedInUserKey();
            encrypedBoards = this.boardsRepo.getPrivateBoards(userKey);
        }
        return encrypedBoards.stream().map(encryptedBoard -> this.recoverBoard((EncryptedBoardModel)encryptedBoard)).filter(board -> board != null).collect(Collectors.toList());
    }

    @Override
    public List getAllSharedWithMeBoards(Boolean expand) {
        List boardIds = Collections.emptyList();
        List<String> sharedBoardIds = this.boardPermissionsController.getAccesibleBoardIdsForLoggedUser();
        if (!sharedBoardIds.isEmpty()) {
            List<String> userBoards = this.boardsRepo.getAllBoardKeys(this.dhUserService.getLoggedInUserKey());
            boardIds = sharedBoardIds.stream().filter(sharedId -> !userBoards.contains(sharedId)).collect(Collectors.toList());
        }
        return expand == false ? boardIds : boardIds.stream().map(this::getBoard).collect(Collectors.toList());
    }

    @Override
    public BoardModel getUserBoard(String user, String id, Boolean global) throws Exception {
        BoardModel board = this.getBoard(id, global);
        return board.getOwner().equals(user) ? board : null;
    }

    @Override
    public BoardModel addBoard(BoardModel board) throws Exception {
        this.validateBoard(board);
        this.boardTokenController.updateToken(board);
        EncryptedBoardModel encrypted = this.generateEncryptedBoard(board);
        EncryptedBoardModel savedEncrypted = this.boardsRepo.addBoard(encrypted);
        String json = this.mCrypto.decryptBackend(savedEncrypted.getData());
        BoardModel newBoard = (BoardModel)this.mMapper.readValue(json, BoardModel.class);
        this.boardPermissionsController.updateBoardPermissions(newBoard);
        return newBoard;
    }

    @Override
    public BoardModel updateBoard(BoardModel board) throws Exception {
        this.validateBoard(board);
        this.boardTokenController.updateToken(board);
        EncryptedBoardModel encrypted = this.generateEncryptedBoard(board);
        EncryptedBoardModel savedEncrypted = this.boardsRepo.updateBoard(encrypted);
        String json = this.mCrypto.decryptBackend(savedEncrypted.getData());
        BoardModel updatedBoard = (BoardModel)this.mMapper.readValue(json, BoardModel.class);
        this.boardPermissionsController.updateBoardPermissions(updatedBoard);
        return updatedBoard;
    }

    @Override
    public boolean removeBoard(String boardId, Boolean global) throws Exception {
        String userKey = this.dhUserService.getLoggedInUserKey();
        if (!this.dhUserService.isLoggedUserAdmin().booleanValue() && this.getUserBoard(userKey, boardId, global) == null) {
            log.error("Problems with board: User not allowed to remove board.");
            return false;
        }
        boolean removed = this.boardsRepo.removeBoard(boardId);
        if (removed) {
            this.boardPermissionsController.removeBoardPermissions(boardId);
            this.boardUserPreferencesController.removeBoardUserPreferences(boardId);
        }
        return removed;
    }

    private BoardSharingModel getSharingByAction(BoardSharingModel sharing) {
        BoardSharingModel newSharing;
        if (sharing != null && sharing.getAction() != null) {
            newSharing = new BoardSharingModel();
            newSharing.setPublic(sharing.getPublic());
            newSharing.setPassword(sharing.getPassword());
            switch (sharing.getAction()) {
                case "delete_password": {
                    newSharing.setPassword(null);
                    break;
                }
                default: {
                    String hashedPass = this.mCrypto.hashString(sharing.getPassword());
                    newSharing.setPassword(hashedPass);
                    break;
                }
            }
        } else {
            newSharing = sharing;
        }
        return newSharing;
    }

    EncryptedBoardModel generateEncryptedBoard(BoardModel board) throws Exception {
        EncryptedBoardModel encrypted = new EncryptedBoardModel();
        encrypted.setId(board.getId());
        encrypted.setName(board.getName());
        encrypted.setOwner(board.getOwner());
        encrypted.setCreated(board.getCreated());
        encrypted.setUpdated(board.getUpdated());
        encrypted.setGlobal(board.getGlobal());
        board.setSharing(this.getSharingByAction(board.getSharing()));
        String json = this.mMapper.writeValueAsString((Object)board);
        encrypted.setData(this.mCrypto.encryptBackend(json));
        return encrypted;
    }

    BoardModel recoverBoard(EncryptedBoardModel encryptedBoard) {
        BoardModel result = null;
        if (encryptedBoard != null) {
            try {
                String json = this.mCrypto.decryptBackend(encryptedBoard.getData());
                result = (BoardModel)this.mMapper.readValue(json, BoardModel.class);
            }
            catch (Exception e) {
                log.error("Problems with board: " + encryptedBoard.getId(), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public boolean checkUserLoggedCanView(BoardModel board) {
        return this.boardAccessManager.canUserLoggedInView(board);
    }

    @Override
    public boolean checkUserLoggedCanEdit(BoardModel board) {
        return this.boardAccessManager.canUserLoggedInEdit(board);
    }

    @Override
    public BoardModel cloneBoard(BoardModel board, String originalBoardId) throws Exception {
        BoardModel originalBoard = this.getBoard(originalBoardId);
        this.validateClonedBoard(originalBoard);
        List<List<GadgetModel>> newData = originalBoard.getData().stream().map(slide -> slide.stream().map(gadget -> {
            gadget.setId(UUID.randomUUID().toString());
            return gadget;
        }).collect(Collectors.toList())).collect(Collectors.toList());
        this.boardTokenController.updateToken(board);
        board.setData(newData);
        board.setProduct(originalBoard.getProduct());
        board.setConfig(originalBoard.getConfig());
        EncryptedBoardModel encrypted = this.generateEncryptedBoard(board);
        EncryptedBoardModel savedEncrypted = this.boardsRepo.addBoard(encrypted);
        String json = this.mCrypto.decryptBackend(savedEncrypted.getData());
        BoardModel newBoard = (BoardModel)this.mMapper.readValue(json, BoardModel.class);
        this.boardPermissionsController.updateBoardPermissions(newBoard);
        return newBoard;
    }

    private void validateBoard(BoardModel board) throws GadgetValidatorException {
        BoardModel originalBoard = this.getBoard(board.getId());
        ValidationResponse validationResponse = this.validationController.validateDataFor(board, originalBoard);
        if (!validationResponse.isValid()) {
            log.error(validationResponse.getError());
            throw new GadgetValidatorException(validationResponse.getError());
        }
    }

    private void validateClonedBoard(BoardModel originalBoard) throws GadgetValidatorException {
        ValidationResponse validationResponse = this.validationController.validateDataForCloned(originalBoard);
        if (!validationResponse.isValid()) {
            log.error(validationResponse.getError());
            throw new GadgetValidatorException(validationResponse.getError());
        }
    }
}

