/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.proxy;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import java.net.URL;
import java.net.URLConnection;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/resource")
public class ProxyModule {
    private static final Logger log = LoggerFactory.getLogger(ProxyModule.class);
    @Inject
    private Crypto crypto;

    private static final String getExpirationTime() {
        return DateTime.now().plusYears(1).toDateTime(DateTimeZone.UTC).toString();
    }

    @GET
    @Path(value="/{data:.*}")
    @Produces(value={"*/*"})
    @AnonymousAllowed
    public Response proxy(@PathParam(value="data") String data) {
        String target = null;
        try {
            target = this.crypto.decryptFrontend(data);
            log.debug("Path requested -> " + target);
        }
        catch (Exception e) {
            log.error("Problems with a request at proxy", (Object)e.getMessage());
            return Response.status((int)400).build();
        }
        try {
            URLConnection connection = new URL(target).openConnection();
            connection.connect();
            return Response.ok().header("Expires", (Object)ProxyModule.getExpirationTime()).entity((Object)connection.getInputStream()).build();
        }
        catch (Exception e) {
            log.error("Problems with a request at proxy", (Throwable)e);
            return Response.status((int)404).header("Expires", (Object)ProxyModule.getExpirationTime()).build();
        }
    }
}

