/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.utils.crypto;

import com.atlassian.crowd.password.encoder.BCryptPasswordEncoder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.roninpixels.dashboardhub.services.ApplicationPropertiesAccesor;
import com.roninpixels.dashboardhub.services.DHDefaultConfigGenerator;
import com.roninpixels.dashboardhub.services.DashboardHubPluginManager;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.crypto.CryptoTool;
import com.roninpixels.dashboardhub.utils.crypto.FrontendCryptoTool;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CryptoImpl
implements Crypto {
    private static final Logger log = LoggerFactory.getLogger(CryptoImpl.class);
    public static final String APP_PROPERTIES_KEY = "DASHBOARDHUB-RP";
    private static final String DS_KEY_PROPERTY = "DS-KEY";
    @Inject
    private DHDefaultConfigGenerator generator;
    @Inject
    private DashboardHubPluginManager pluginManager;
    @Inject
    private ApplicationPropertiesAccesor propertiesAccesor;
    @Inject
    @ComponentImport
    private PluginSettingsFactory pluginSettingsFactory;
    private final String fs = "/ZnuDujqrJC7gF7bexeCEx4iEEOq14JobA2ML456mUwXNQSuUiw9/luHVTOsCidN";
    private final String s = "DVITERdeHg=";
    private CryptoTool backendTool;
    private FrontendCryptoTool frontendTool;
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    private CryptoTool dsTool;

    @PostConstruct
    public void init() throws GeneralSecurityException {
        String bs = "Q3xWMlY6WVN" + this.propertiesAccesor.getToken() + this.pluginManager.getDataService();
        this.backendTool = new CryptoTool(this.digest(bs));
        this.frontendTool = new FrontendCryptoTool(this.getFs(this.backendTool, "/ZnuDujqrJC7gF7bexeCEx4iEEOq14JobA2ML456mUwXNQSuUiw9/luHVTOsCidN"));
        this.bCryptPasswordEncoder = new BCryptPasswordEncoder();
        this.dsTool = this.initDatasourceTool();
    }

    @Override
    public String decryptFrontend(String encryptedData) throws GeneralSecurityException {
        return this.frontendTool.decrypt(encryptedData);
    }

    @Override
    public String encryptBackend(String data) throws GeneralSecurityException {
        return this.dsTool.encrypt(data);
    }

    @Override
    public String decryptBackend(String encryptedData) throws GeneralSecurityException {
        try {
            return this.dsTool.decrypt(encryptedData);
        }
        catch (Exception e) {
            return this.backendTool.decrypt(encryptedData);
        }
    }

    @Override
    public String hashString(String pass) {
        return this.bCryptPasswordEncoder.encodePassword(pass, null);
    }

    @Override
    public boolean isHashValid(String encPass, String rawPass) {
        return this.bCryptPasswordEncoder.isPasswordValid(encPass, rawPass, null);
    }

    String getFs(CryptoTool tool, String data) throws GeneralSecurityException {
        String tmp = tool.decrypt(data);
        return new String(Base64.getDecoder().decode(tmp), StandardCharsets.UTF_8);
    }

    String digest(String input) {
        return new String(Base64.getDecoder().decode((input + "DVITERdeHg=").getBytes()), StandardCharsets.UTF_8);
    }

    CryptoTool initDatasourceTool() throws GeneralSecurityException {
        String actualKey;
        String storedDsKey;
        PluginSettings ps = this.pluginSettingsFactory.createSettingsForKey(APP_PROPERTIES_KEY);
        Object storedData = ps.get(DS_KEY_PROPERTY);
        String string = storedDsKey = storedData != null ? (String)storedData : null;
        if (storedDsKey == null) {
            actualKey = this.backendTool.generateKey();
            ps.put(DS_KEY_PROPERTY, (Object)this.backendTool.encrypt(actualKey));
        } else {
            actualKey = this.backendTool.decrypt(storedDsKey);
        }
        return new CryptoTool(actualKey, true);
    }
}

