/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.migrations.impl;

import com.roninpixels.dashboardhub.migrations.DHMigrationTask;
import com.roninpixels.dashboardhub.migrations.DHTaskPriority;
import com.roninpixels.dashboardhub.migrations.DHTasksEngine;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DefaultDHMigrationTasksEngine
implements DHTasksEngine {
    private static final Logger log = LoggerFactory.getLogger(DefaultDHMigrationTasksEngine.class);

    @Override
    public void executeTasks(List<DHMigrationTask> tasks) {
        this.sort(tasks).stream().forEach(task -> {
            try {
                task.execute();
            }
            catch (Exception e) {
                log.error("A dashboard hub task threw an error -> " + e.getMessage());
            }
        });
    }

    List<DHMigrationTask> sort(List<DHMigrationTask> tasks) {
        return tasks.stream().sorted(Comparator.comparingInt(this::getTaskPriority)).collect(Collectors.toList());
    }

    int getTaskPriority(DHMigrationTask task) {
        DHTaskPriority priority = task.getClass().getAnnotation(DHTaskPriority.class);
        return priority == null ? Integer.MAX_VALUE : priority.value();
    }
}

