/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.statusPage;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.StatusPageConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequester;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

public abstract class StatusPageGadgetRequesterBase
implements GadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(StatusPageGadgetRequesterBase.class);
    @Inject
    private ConnectorsProvider provider;
    StatusPageConnector statusPageConnector;
    private ObjectMapper mapper = new ObjectMapper();

    @Override
    public void init(DatasourceModel datasource) {
        this.statusPageConnector = (StatusPageConnector)this.provider.getConnector(datasource);
        if (this.statusPageConnector == null) {
            throw new IllegalArgumentException("Datasource is not valid for gadget requester: " + this.getClass().getAnnotation(Component.class));
        }
    }

    protected <T> T checkStatusAndParse(ResponseEntity<String> response, Class<T> clazz) throws Exception {
        if (response.getStatusCode().value() >= 400) {
            throw new BadRequestToSourceException(response);
        }
        return (T)this.mapper.readValue((String)response.getBody(), clazz);
    }

    Map getPage(String pageId) throws Exception {
        ResponseEntity<String> resp = this.statusPageConnector.getPage(pageId);
        return this.checkStatusAndParse(resp, Map.class);
    }
}

