/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.SprintBurndownConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprintResolvedIssues
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(SprintResolvedIssues.class);
    private static final String[] SPRINT_STATES = new String[]{"active", "closed"};

    private List getSprints(Long boardId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("state", String.join((CharSequence)",", SPRINT_STATES));
        return JiraSprintDataUtils.getSprintsWithProjects(this.jiraConnector, boardId, params);
    }

    private List getSprintDoneIssues(Map sprintId, List<String> metric, String sprintClause) {
        List<String> fields = null;
        if (metric != null) {
            fields = JiraSprintDataUtils.extractFieldsNamesFromMetric(metric);
        }
        return this.execJQLwithFilterFields(String.format("statusCategory = Done AND %s = %s", sprintClause, sprintId.get("id")), fields, null, null, null, "");
    }

    Map getLastSprint(List<Map> sprints) {
        return sprints.stream().filter(sprint -> "closed".equals(sprint.get("state"))).sorted((sp1, sp2) -> {
            DateTime d1 = DateTime.parse((String)((String)sp1.get("completeDate")));
            DateTime d2 = DateTime.parse((String)((String)sp2.get("completeDate")));
            return (int)(d2.getMillis() - d1.getMillis());
        }).findFirst().orElse(null);
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        SprintBurndownConfig config = GadgetRequesterUtils.getConfig(gadget, SprintBurndownConfig.class);
        String sprintClause = extraParams.isEmpty() ? "Sprint" : extraParams.get(0);
        List sprints = this.getSprints(config.getBoard());
        Map activeSprint = JiraSprintDataUtils.getActiveSprint(sprints, config.getBoard());
        if (activeSprint == null) {
            activeSprint = JiraSprintDataUtils.getActiveSprint(sprints);
        } else {
            sprints = sprints.stream().filter(sprint -> config.getBoard().equals(sprint.get("originBoardId"))).collect(Collectors.toList());
        }
        if (activeSprint == null) {
            return this.generateResponse(null, null, null, null);
        }
        Map lastSprint = this.getLastSprint(sprints);
        List<Map> sprintWithIssues = Arrays.asList(activeSprint, lastSprint);
        List sprintsIssues = sprintWithIssues.parallelStream().filter(Objects::nonNull).map(sprint -> this.getSprintDoneIssues((Map)sprint, config.getMetric(), sprintClause)).collect(Collectors.toList());
        return this.generateResponse(sprints, lastSprint, (List)sprintsIssues.get(0), lastSprint == null ? null : (List)sprintsIssues.get(1));
    }

    private Map<String, ?> generateResponse(List sprints, Map lastSprint, List currentIssues, List lastIssues) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("sprints", sprints != null ? sprints : Collections.emptyList());
        res.put("currentIssues", currentIssues != null ? currentIssues : Collections.emptyList());
        res.put("lastIssues", lastIssues != null ? lastIssues : Collections.emptyList());
        if (lastSprint != null) {
            res.put("lastSprint", lastSprint);
        }
        return res;
    }
}

