/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers;

import com.atlassian.activeobjects.tx.Transactional;
import com.roninpixels.dashboardhub.controllers.AddonPropertiesController;
import com.roninpixels.dashboardhub.controllers.ResponseMessage;
import com.roninpixels.dashboardhub.controllers.UserPropertiesController;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.BoardSharingModel;
import com.roninpixels.dashboardhub.web.models.EncryptedBoardModel;
import com.roninpixels.dashboardhub.web.models.PropertyModel;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Service;

@Service
@Transactional
@Deprecated
public class BoardsController {
    public static final String PROPERTY_WALLBOARDS = "wallboards";
    @Inject
    private DHUserService dhUserService;
    @Inject
    private AddonPropertiesController propertiesController;
    @Inject
    private UserPropertiesController userPropertiesController;
    @Inject
    private Crypto mCrypto;
    @Inject
    private TokenGenerator tokenGenerator;
    private final ObjectMapper mMapper = new ObjectMapper();

    private List<String> getBoardIds(Boolean global, String userKey) throws IOException {
        PropertyModel property = global != false ? this.propertiesController.get(PROPERTY_WALLBOARDS) : this.userPropertiesController.get(userKey, PROPERTY_WALLBOARDS);
        return property == null ? Collections.emptyList() : (List)this.mMapper.convertValue(property.getValue(), List.class);
    }

    public BoardModel getBoard(String id, Boolean global) {
        try {
            PropertyModel property;
            PropertyModel propertyModel = property = global != false ? this.propertiesController.get(id) : this.userPropertiesController.get(id);
            if (property == null) {
                return null;
            }
            EncryptedBoardModel encrypted = (EncryptedBoardModel)this.mMapper.convertValue(property.getValue(), EncryptedBoardModel.class);
            String json = this.mCrypto.decryptBackend(encrypted.getData());
            return (BoardModel)this.mMapper.readValue(json, BoardModel.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List getAllBoards(Boolean global, Boolean expand) throws Exception {
        List<String> boards = this.getBoardIds(global, null);
        if (!expand.booleanValue()) {
            return boards;
        }
        return boards.stream().map(boardId -> this.getBoard((String)boardId, global)).filter(board -> board != null).collect(Collectors.toList());
    }

    public List<String> getAllUserBoards(String userKey) throws IOException {
        PropertyModel property = this.userPropertiesController.get(userKey, PROPERTY_WALLBOARDS);
        return property == null ? Collections.emptyList() : (List)this.mMapper.convertValue(property.getValue(), List.class);
    }

    public BoardModel getUserBoard(String user, String id, Boolean global) throws Exception {
        PropertyModel property;
        PropertyModel propertyModel = property = global != false ? this.propertiesController.get(id) : this.userPropertiesController.get(user, id);
        if (property == null) {
            return null;
        }
        EncryptedBoardModel encrypted = (EncryptedBoardModel)this.mMapper.convertValue(property.getValue(), EncryptedBoardModel.class);
        String json = this.mCrypto.decryptBackend(encrypted.getData());
        return (BoardModel)this.mMapper.readValue(json, BoardModel.class);
    }

    ResponseMessage updateGlobalProperties(String boardId, boolean isGlobal, boolean addNew) throws IOException {
        return this.updateGlobalProperties(null, boardId, isGlobal, addNew);
    }

    ResponseMessage updateGlobalProperties(String userKey, String boardId, boolean isGlobal, boolean addNew) throws IOException {
        boolean actionPerformed;
        ArrayList<String> newValue = new ArrayList<String>(this.getBoardIds(isGlobal, userKey));
        boolean bl = actionPerformed = addNew ? newValue.add(boardId) : newValue.remove(boardId);
        if (actionPerformed) {
            return isGlobal ? this.propertiesController.createOrUpdate(PROPERTY_WALLBOARDS, newValue) : this.userPropertiesController.createOrUpdate(userKey, PROPERTY_WALLBOARDS, newValue);
        }
        return ResponseMessage.ERROR;
    }

    EncryptedBoardModel generateEncryptedBoard(BoardModel board) throws Exception {
        EncryptedBoardModel encrypted = new EncryptedBoardModel();
        encrypted.setId(board.getId());
        encrypted.setName(board.getName());
        encrypted.setOwner(board.getOwner());
        encrypted.setCreated(board.getCreated());
        encrypted.setUpdated(board.getUpdated());
        board.setSharing(this.getSharingByAction(board.getSharing()));
        String json = this.mMapper.writeValueAsString((Object)board);
        encrypted.setData(this.mCrypto.encryptBackend(json));
        return encrypted;
    }

    public BoardModel addBoard(BoardModel board) throws Exception {
        EncryptedBoardModel encrypted = this.generateEncryptedBoard(board);
        ResponseMessage action = board.getGlobal() != false ? this.propertiesController.createOrUpdate(board.getId(), encrypted) : this.userPropertiesController.createOrUpdate(board.getId(), encrypted);
        if (action.equals((Object)ResponseMessage.CREATED)) {
            this.updateGlobalProperties(board.getId(), board.getGlobal(), true);
        }
        return board;
    }

    public BoardModel updateBoard(BoardModel board) throws Exception {
        TokenContentModel tokenContent = this.tokenGenerator.getTokenContent(board.getToken());
        if (!tokenContent.getGlobal().equals(board.getGlobal())) {
            this.removeBoard(tokenContent.getBoardId(), tokenContent.getGlobal());
        }
        return this.addBoard(board);
    }

    public boolean removeBoard(String boardId, Boolean global) {
        ResponseMessage res;
        ResponseMessage responseMessage = res = global != false ? this.propertiesController.delete(boardId) : this.userPropertiesController.delete(boardId);
        if (res != ResponseMessage.DELETED) {
            return false;
        }
        try {
            return ResponseMessage.UPDATED == this.updateGlobalProperties(boardId, global, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean removeUserBoard(String userKey, String boardId, Boolean global) {
        ResponseMessage res;
        ResponseMessage responseMessage = res = global != false ? this.propertiesController.delete(boardId) : this.userPropertiesController.delete(userKey, boardId);
        if (res != ResponseMessage.DELETED) {
            return false;
        }
        try {
            return ResponseMessage.UPDATED == this.updateGlobalProperties(userKey, boardId, global, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private BoardSharingModel getSharingByAction(BoardSharingModel sharing) {
        BoardSharingModel newSharing;
        if (sharing != null && sharing.getAction() != null) {
            newSharing = new BoardSharingModel();
            newSharing.setPublic(sharing.getPublic());
            newSharing.setPassword(sharing.getPassword());
            switch (sharing.getAction()) {
                case "delete_password": {
                    newSharing.setPassword(null);
                    break;
                }
                default: {
                    String hashedPass = this.mCrypto.hashString(sharing.getPassword());
                    newSharing.setPassword(hashedPass);
                    break;
                }
            }
        } else {
            newSharing = sharing;
        }
        return newSharing;
    }
}

