/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.common.functions;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class ServiceDeskAndQueues {
    private static final Logger log = LoggerFactory.getLogger(ServiceDeskAndQueues.class);
    private final ServerConnector jiraServerConnector;
    private static final Map<String, String> EXPERIMENTAL_HEADERS;

    public ServiceDeskAndQueues(ServerConnector jiraServerConnector) {
        this.jiraServerConnector = jiraServerConnector;
    }

    private static String getProjectId(String serviceDeskId) {
        return serviceDeskId.replace("projectId:", "");
    }

    private List<Map> getAllElements(String path, Map<String, ?> params, int maxElements) {
        return this.getAllElements(path, params, maxElements, null);
    }

    private List<Map> getAllElements(String path, Map<String, ?> params, int maxElements, Map<String, String> headers) {
        HashMap mParams = params != null ? new HashMap(params) : new HashMap();
        mParams.putIfAbsent("start", 0);
        mParams.putIfAbsent("limit", 100);
        boolean getMore = true;
        LinkedList<Map> data = new LinkedList<Map>();
        while (getMore) {
            ResponseEntity<Map> response = this.jiraServerConnector.executeRequest(Request.MethodType.GET, path, params, headers, Map.class);
            ResponseChecker.checkStatus(response);
            Map responseData = (Map)response.getBody();
            List values = (List)responseData.get("values");
            data.addAll(values);
            mParams.put("start", (Integer)responseData.get("start") + (Integer)responseData.get("limit"));
            boolean isLastPage = responseData.getOrDefault("isLastPage", false);
            getMore = !values.isEmpty() && !isLastPage && data.size() < maxElements;
        }
        return data;
    }

    public List<Map> getAllServiceDesks(Map<String, ?> params) {
        String serviceDeskPath = "/rest/servicedeskapi/servicedesk";
        return this.getAllElements("/rest/servicedeskapi/servicedesk", params, 1000);
    }

    public ResponseEntity<Map> getServiceDesk(String projectId, Map<String, ?> params) throws Exception {
        HashMap mParams = params != null ? new HashMap(params) : new HashMap();
        mParams.putIfAbsent("start", 0);
        mParams.putIfAbsent("limit", 50);
        ResponseEntity<Map> response;
        while ((response = this.jiraServerConnector.executeRequest("/rest/servicedeskapi/servicedesk", params, Map.class)).getStatusCode().value() < 400) {
            Map responseData = (Map)response.getBody();
            List values = (List)responseData.get("values");
            Map serviceDesk = values.stream().filter(value -> projectId.equals(value.get("projectId"))).findFirst().orElse(null);
            if (serviceDesk != null) {
                return new ResponseEntity((Object)serviceDesk, response.getStatusCode());
            }
            if (responseData.get("isLastPage") == Boolean.TRUE) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            mParams.put("start", (Integer)responseData.get("start") + (Integer)responseData.get("limit"));
        }
        return response;
    }

    private String getServiceDeskId(String candidateId) throws Exception {
        if (candidateId.contains("projectId:")) {
            String _projectId = ServiceDeskAndQueues.getProjectId(candidateId);
            Map serviceDesk = (Map)this.getServiceDesk(_projectId, null).getBody();
            return (String)serviceDesk.get("id");
        }
        return candidateId;
    }

    public ResponseEntity<Map> getQueue(String serviceDeskId, String queueId) throws Exception {
        String id = this.getServiceDeskId(serviceDeskId);
        String uri = String.format("/rest/servicedeskapi/servicedesk/%s/queue/%s", id, queueId);
        ResponseEntity<Map> responseEntity = this.jiraServerConnector.executeRequest(Request.MethodType.GET, uri, null, EXPERIMENTAL_HEADERS, Map.class);
        ResponseChecker.checkStatus(responseEntity);
        return responseEntity;
    }

    public ResponseEntity<List> getQueues(String serviceDeskId, Map<String, ?> params) throws Exception {
        String id = this.getServiceDeskId(serviceDeskId);
        List data = this.getQueuesWithServiceDeskId(id, params);
        return new ResponseEntity((Object)data, HttpStatus.OK);
    }

    private List getQueuesWithServiceDeskId(String serviceDeskId, Map params) throws Exception {
        String uri = String.format("/rest/servicedeskapi/servicedesk/%s/queue", serviceDeskId);
        List<Map> queues = this.getAllElements(uri, params, 1000, EXPERIMENTAL_HEADERS);
        return queues;
    }

    static {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-ExperimentalApi", "opt-in");
        EXPERIMENTAL_HEADERS = Collections.unmodifiableMap(headers);
    }
}

