/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.factories;

import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.BearerTokenAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.connectors.factories.ConnectorFactory;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.datacenter.BitbucketDatacenterConnectorImpl;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnectorConfiguration;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.RestAuthStrategyFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.ServerConnectorFactory;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.globals.Product;
import com.roninpixels.dashboardhub.globals.ProductHosting;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class BitbucketDCRestConnectorFactory
implements ConnectorFactory {
    @Inject
    private ServerConnectorFactory serverConnectorFactory;
    @Inject
    private RestAuthStrategyFactory authStrategyFactory;
    @Inject
    private Crypto crypto;

    @Override
    public DHConnector createConnector(DatasourceModel ds) {
        RestAuthStrategy strategy = this.authStrategyFactory.getRestAuthStrategy(BearerTokenAuthStrategy.class, ds);
        return new BitbucketDatacenterConnectorImpl(this.serverConnectorFactory.getServerConnector(ds, strategy, this.getConnectorConfig(ds)));
    }

    @Override
    public boolean match(DatasourceModel ds) {
        return ds.getProduct().equals(Product.BITBUCKET.value()) && ProductHosting.DATACENTER.value().equals(ds.getType());
    }

    private ServerConnectorConfiguration getConnectorConfig(DatasourceModel ds) {
        DsOptionsModel options = ds.getOptions() == null ? DatasourcesUtil.getOptions(this.crypto, ds.getToken()) : ds.getOptions();
        ServerConnectorConfiguration config = new ServerConnectorConfiguration();
        if (options.getOtherConfig() != null && options.getOtherConfig().get("options") != null) {
            Map hiddenOptions = (Map)options.getOtherConfig().get("options");
            config.setProperty("projectKey", hiddenOptions.get("projectKey"));
        }
        return config;
    }
}

