/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.migrations.v1_3_4;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.roninpixels.dashboardhub.ao.UserProperty;
import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.controllers.BoardsControllerV2;
import com.roninpixels.dashboardhub.migrations.DHMigrationTask;
import com.roninpixels.dashboardhub.migrations.DHTaskPriority;
import com.roninpixels.dashboardhub.store.AddonPropertiesRepository;
import com.roninpixels.dashboardhub.store.impl.UserPropertiesRepositoryImpl;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@DHTaskPriority(value=30)
public class BoardsFromControllerV1toV2
implements DHMigrationTask {
    private static final Logger log = LoggerFactory.getLogger(BoardsFromControllerV1toV2.class);
    private static final boolean DELETE_FROM_OLD_REPO = false;
    @Autowired
    @ComponentImport
    private ActiveObjects ao;
    @Autowired
    private AddonPropertiesRepository addonPropsRepo;
    @Autowired
    private UserPropertiesRepositoryImpl userPropsRepo;
    @Autowired
    private BoardsController oldBoardsController;
    @Autowired
    private BoardsControllerV2 boardsControllerV2;

    @Override
    public void execute() {
        try {
            this.migrateGlobalBoards();
            this.migratePrivateBoards();
        }
        catch (Exception e) {
            log.error("Problems migrating boards to v1.3.4", (Throwable)e);
        }
    }

    private void migrateGlobalBoards() throws Exception {
        boolean isGlobal = true;
        List boards = this.oldBoardsController.getAllBoards(true, true);
        for (BoardModel board : boards) {
            boolean migrated = this.isBoardMigrated(board.getId());
            if (!migrated) {
                try {
                    migrated = this.boardsControllerV2.addBoard(board) != null;
                }
                catch (Exception e) {
                    log.error(String.format("Problems migrating a board from v1 to v2: %s", board.getId()), (Throwable)e);
                }
            }
            if (!migrated) continue;
        }
    }

    private void migratePrivateBoards() throws Exception {
        UserProperty[] props = (UserProperty[])this.ao.find(UserProperty.class, "KEY = ?", new Object[]{"wallboards"});
        List users = Arrays.stream(props).map(prop -> prop.getUserKey()).collect(Collectors.toList());
        for (String userKey : users) {
            this.migrateUserPrivateBoards(userKey);
        }
    }

    private void migrateUserPrivateBoards(String userKey) throws Exception {
        boolean isGlobal = false;
        List<String> boardsKeys = this.oldBoardsController.getAllUserBoards(userKey);
        for (String boardKey : boardsKeys) {
            boolean migrated = this.isBoardMigrated(boardKey);
            if (!migrated) {
                BoardModel board = this.oldBoardsController.getUserBoard(userKey, boardKey, false);
                try {
                    migrated = this.boardsControllerV2.addBoard(board) != null;
                }
                catch (Exception e) {
                    log.error(String.format("Problems migrating a private board from v1 to v2. User key: %s. Board: %s", userKey, boardKey), (Throwable)e);
                }
            }
            if (!migrated) continue;
        }
    }

    private boolean isBoardMigrated(String boardId) {
        try {
            return this.boardsControllerV2.getBoard(boardId) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

