/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest;

import com.roninpixels.dashboardhub.controllers.ResponseMessage;
import com.roninpixels.dashboardhub.controllers.UserPropertiesController;
import com.roninpixels.dashboardhub.web.models.PropertyModel;
import com.roninpixels.dashboardhub.web.rest.MessagesUtil;
import com.roninpixels.dashboardhub.web.rest.OperationMessage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/user/properties")
public class UserPropertiesEndpoint {
    private static final Logger log = LoggerFactory.getLogger(UserPropertiesEndpoint.class);
    @Inject
    private UserPropertiesController controller;

    @GET
    @Path(value="/{key}")
    @Produces(value={"application/json"})
    public Response getProperty(@NotNull @PathParam(value="key") String key) {
        try {
            PropertyModel property = this.controller.get(key);
            if (property != null) {
                return Response.ok((Object)property).build();
            }
        }
        catch (Exception e) {
            log.error("Problems getting a user property: " + key, (Throwable)e);
            return Response.status((int)500).build();
        }
        OperationMessage op = new OperationMessage("Property not found.", 404);
        return Response.status((int)404).entity((Object)op).build();
    }

    @PUT
    @Path(value="/{key}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setProperty(@NotNull @PathParam(value="key") String key, @Context HttpServletRequest request, InputStream requestBody) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            BufferedReader reader = new BufferedReader(new InputStreamReader(requestBody));
            JsonNode value = mapper.readTree((Reader)reader);
            reader.close();
            Object actualValue = value.isArray() ? mapper.convertValue((Object)value, (TypeReference)new TypeReference<List<Object>>(){}) : (value.isContainerNode() ? mapper.convertValue((Object)value, (TypeReference)new TypeReference<Map<String, Object>>(){}) : value.getTextValue());
            ResponseMessage res = this.controller.createOrUpdate(key, actualValue);
            OperationMessage op = MessagesUtil.createdOP(res, "Property");
            return Response.status((int)op.getStatusCode()).entity((Object)op).build();
        }
        catch (Exception e) {
            log.error("Problems updating a property: " + key, (Throwable)e);
            return Response.status((int)404).build();
        }
    }

    @DELETE
    @Path(value="/{key}")
    @Produces(value={"application/json"})
    public Response removeProperty(@NotNull @PathParam(value="key") String key) {
        ResponseMessage res = this.controller.delete(key);
        if (res == ResponseMessage.DELETED) {
            return Response.status((int)204).build();
        }
        OperationMessage op = new OperationMessage("Bad request", 400);
        return Response.ok((Object)op).build();
    }
}

