/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.projectrak.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.ProjectrakConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.web.rest.jira.api.GenericJiraEndpoint;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/projectrak/v1/fields")
public class FieldsEndpoint {
    private static final Logger log = LoggerFactory.getLogger(FieldsEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response get(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        String urlTarget = "not defined";
        try {
            ProjectrakConnector projectrak = (ProjectrakConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            urlTarget = projectrak.getURL();
            List<Map> response = projectrak.getFields(true);
            return Response.ok(response).build();
        }
        catch (BadRequestToSourceException bre) {
            log.error("Problems getting projectrak fields from " + urlTarget, (Throwable)bre);
            return GenericJiraEndpoint.generateResponse(bre);
        }
        catch (Exception e) {
            log.error("Problems getting projectrak fields from " + urlTarget, (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

