/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.dashboardHub.boards;

import com.roninpixels.dashboardhub.controllers.BoardsControllerV2;
import com.roninpixels.dashboardhub.gadgetsValidators.GadgetValidatorException;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.rest.MessagesUtil;
import com.roninpixels.dashboardhub.web.rest.dashboardHub.boards.BoardsMessageModel;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/board")
public class BoardsV1Endpoint {
    private static final Logger log = LoggerFactory.getLogger(BoardsV1Endpoint.class);
    @Inject
    private BoardsControllerV2 boardsController;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getBoards(@DefaultValue(value="true") @QueryParam(value="global") Boolean global, @DefaultValue(value="false") @QueryParam(value="expand") Boolean expand, @DefaultValue(value="false") @QueryParam(value="sharedWithMe") Boolean sharedWithMe) {
        try {
            List boards = sharedWithMe != false ? this.boardsController.getAllSharedWithMeBoards(expand) : this.boardsController.getAllBoards(global, expand);
            ObjectMapper mapper = new ObjectMapper();
            HashMap<String, List> data = new HashMap<String, List>();
            data.put("boards", boards);
            return Response.ok((Object)mapper.writeValueAsString(data)).build();
        }
        catch (Exception e) {
            log.error(String.format("Problems getting a board -> global: %s, expand: %s", global, expand), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getBoardById(@NotNull @PathParam(value="id") String id, @DefaultValue(value="true") @QueryParam(value="global") Boolean global) {
        try {
            BoardModel board = this.boardsController.getBoard(id, global);
            if (board == null) {
                return Response.status((int)404).build();
            }
            if (!this.boardsController.checkUserLoggedCanView(board)) {
                return MessagesUtil.generateErrorResponse(403, "FORBIDDEN");
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRAP_ROOT_VALUE});
            return Response.ok((Object)mapper.writeValueAsString((Object)board)).build();
        }
        catch (Exception e) {
            log.error("Problems getting a board with id -> " + id, (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setBoard(BoardsMessageModel message) {
        try {
            BoardModel board = message.getBoard();
            BoardModel newBoard = this.boardsController.addBoard(board);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRAP_ROOT_VALUE});
            return Response.ok((Object)mapper.writeValueAsString((Object)newBoard)).build();
        }
        catch (GadgetValidatorException ge) {
            return MessagesUtil.generateValidationErrorResponse();
        }
        catch (Exception e) {
            log.error("Problems creating a board", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setBoard(@NotNull @PathParam(value="id") String id, BoardsMessageModel message) {
        try {
            BoardModel board = message.getBoard();
            board.setShared(null);
            BoardModel oldBoard = this.boardsController.getBoard(board.getId());
            if (!this.boardsController.checkUserLoggedCanEdit(oldBoard)) {
                return MessagesUtil.generateErrorResponse(403, "FORBIDDEN");
            }
            BoardModel newBoard = this.boardsController.updateBoard(board);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRAP_ROOT_VALUE});
            return Response.ok((Object)mapper.writeValueAsString((Object)newBoard)).build();
        }
        catch (GadgetValidatorException ge) {
            return MessagesUtil.generateValidationErrorResponse();
        }
        catch (Exception e) {
            log.error("Problems creating or updating a board - id -> " + id, (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response deleteBoardById(@NotNull @PathParam(value="id") String id, @DefaultValue(value="true") @QueryParam(value="global") Boolean global) {
        try {
            BoardModel storedBoard = this.boardsController.getBoard(id);
            if (!this.boardsController.checkUserLoggedCanEdit(storedBoard)) {
                return MessagesUtil.generateErrorResponse(403, "FORBIDDEN");
            }
            boolean removed = this.boardsController.removeBoard(id, global);
            HashMap<String, String> msg = new HashMap<String, String>();
            if (removed) {
                msg.put("status", "ok");
            } else {
                msg.put("error", "The board couldn't be deleted");
            }
            ObjectMapper mapper = new ObjectMapper();
            return Response.ok((Object)mapper.writeValueAsString(msg)).build();
        }
        catch (Exception e) {
            log.error("Problems deleting the board - id -> " + id, (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

