/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.bitbucket.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.BitbucketConnector;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/bitbucket/v1/repositories")
public class RepositoriesEndpoint {
    private static final Logger log = LoggerFactory.getLogger(RepositoriesEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response getRepositories(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            BitbucketConnector connector = (BitbucketConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("limit", "100");
            ResponseEntity<List> sourceResponse = connector.searchRepositories(params, false);
            int status = sourceResponse.getStatusCodeValue();
            if (status < 400) {
                return Response.status((int)status).entity(sourceResponse.getBody()).build();
            }
            return Response.status((int)400).entity(sourceResponse.getBody()).build();
        }
        catch (Exception e) {
            log.error("Problems searching Bitbucket repositories", (Throwable)e);
            return Response.status((int)400).build();
        }
    }

    @GET
    @Path(value="/search")
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response searchRepositories(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @QueryParam(value="name") String name, @QueryParam(value="slug") String slug, @QueryParam(value="project") String project) {
        try {
            ResponseEntity<List> sourceResponse;
            int status;
            BitbucketConnector connector = (BitbucketConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("limit", "10");
            if (name != null) {
                params.put("name", name);
            }
            if (slug != null) {
                params.put("slug", slug);
            }
            if (project != null) {
                params.put("project", project);
            }
            if ((status = (sourceResponse = connector.searchRepositories(params, false)).getStatusCodeValue()) < 400) {
                return Response.status((int)status).entity(sourceResponse.getBody()).build();
            }
            return Response.status((int)400).entity(sourceResponse.getBody()).build();
        }
        catch (Exception e) {
            log.error("Problems searching Bitbucket repositories", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

