/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.utils.crypto;

import java.security.GeneralSecurityException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class CryptoTool {
    private static final String ALG = "AES";
    private Cipher encrypterCipher;
    private Cipher decrypterCipher;

    public CryptoTool(String key) {
        this(key, false);
    }

    public CryptoTool(String key, boolean isEncoded) {
        byte[] keyBytes = isEncoded ? Base64.getDecoder().decode(key) : key.getBytes();
        this.init(keyBytes);
    }

    private void init(byte[] key) {
        try {
            SecretKeySpec aesKey = new SecretKeySpec(key, ALG);
            Cipher cipher = Cipher.getInstance(ALG);
            cipher.init(1, aesKey);
            Cipher deCipher = Cipher.getInstance(ALG);
            deCipher.init(2, aesKey);
            this.encrypterCipher = cipher;
            this.decrypterCipher = deCipher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String generateKey() throws GeneralSecurityException {
        KeyGenerator keyGen = KeyGenerator.getInstance(ALG);
        keyGen.init(256);
        SecretKey secretKey = keyGen.generateKey();
        return Base64.getEncoder().encodeToString(secretKey.getEncoded());
    }

    public String encrypt(String data) throws GeneralSecurityException {
        byte[] encrypted = this.encrypterCipher.doFinal(data.getBytes());
        return Base64.getEncoder().encodeToString(encrypted);
    }

    public String decrypt(String encryptedData) throws GeneralSecurityException {
        byte[] encrypted = Base64.getDecoder().decode(encryptedData);
        return new String(this.decrypterCipher.doFinal(encrypted));
    }
}

