/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.store.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.roninpixels.dashboardhub.ao.DHPermission;
import com.roninpixels.dashboardhub.store.DHPermissionsRepository;
import com.roninpixels.dashboardhub.store.impl.DHPermissionsQuery;
import com.roninpixels.dashboardhub.web.models.PermissionModel;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.java.ao.DBParam;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DHPermissionsRepositoryImpl
implements DHPermissionsRepository {
    private static final Logger log = LoggerFactory.getLogger(DHPermissionsRepositoryImpl.class);
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private final ObjectMapper mMapper;

    @Inject
    public DHPermissionsRepositoryImpl(ActiveObjects ao, TransactionTemplate transactionTemplate) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
        this.mMapper = new ObjectMapper();
    }

    private DHPermissionsQuery compileQuery(Integer permissionType, Map<String, List<String>> holderIdsByType) {
        StringBuilder queryBuilder = new StringBuilder();
        LinkedList<Object> queryParams = new LinkedList<Object>();
        queryBuilder.append("PERMISSION = ?");
        queryParams.add(permissionType);
        if (holderIdsByType != null && !holderIdsByType.isEmpty()) {
            LinkedList<String> subqueries = new LinkedList<String>();
            for (Map.Entry<String, List<String>> entry : holderIdsByType.entrySet()) {
                String holderType = entry.getKey();
                List<String> holderIds = entry.getValue();
                if (holderIds.isEmpty()) continue;
                String placeholderCommaList = holderIds.stream().map(holderId -> "?").collect(Collectors.joining(", "));
                subqueries.add("HOLDER_TYPE = ? AND HOLDER_ID IN (" + placeholderCommaList + ")");
                queryParams.add(holderType);
                queryParams.addAll(holderIds);
            }
            queryBuilder.append(" AND ( (");
            queryBuilder.append(subqueries.stream().collect(Collectors.joining(") OR (")));
            queryBuilder.append(") )");
        }
        return new DHPermissionsQuery(queryBuilder.toString(), queryParams.toArray());
    }

    private DHPermission[] _getPermissions(Integer permissionType, Map<String, List<String>> holderIdsByType) {
        DHPermissionsQuery permissionsQuery = this.compileQuery(permissionType, holderIdsByType);
        return (DHPermission[])this.ao.find(DHPermission.class, permissionsQuery.compileQuery());
    }

    private PermissionModel txDHPermission(DHPermission permission) {
        PermissionModel model = new PermissionModel();
        model.setId(permission.getID());
        model.setHolderId(permission.getHolderId());
        model.setHolderType(permission.getHolderType());
        model.setPermission(permission.getPermission());
        model.setTargetId(permission.getTargetId());
        model.setTargetType(permission.getTargetType());
        return model;
    }

    private List<PermissionModel> txDHPermission(DHPermission[] permissions) {
        return Arrays.stream(permissions).map(this::txDHPermission).collect(Collectors.toList());
    }

    @Override
    public List<PermissionModel> getPermissions(Integer permissionType) {
        DHPermission[] result = this._getPermissions(permissionType, null);
        return this.txDHPermission(result);
    }

    @Override
    public List<PermissionModel> getPermissions(Integer permission, String targetId) {
        DHPermission[] result = (DHPermission[])this.ao.find(DHPermission.class, "PERMISSION = ? AND TARGET_ID = ?", new Object[]{permission, targetId});
        return this.txDHPermission(result);
    }

    @Override
    public List<PermissionModel> getPermissions(Integer permissionType, Map<String, List<String>> holderIdsByType) {
        DHPermission[] result = this._getPermissions(permissionType, holderIdsByType);
        return this.txDHPermission(result);
    }

    @Override
    public int deletePermissions(Integer permissionType, Map<String, List<String>> holderIdsByType) {
        return (Integer)this.transactionTemplate.execute(() -> {
            DHPermissionsQuery permissionsQuery = this.compileQuery(permissionType, holderIdsByType);
            return this.ao.deleteWithSQL(DHPermission.class, permissionsQuery.getQuery(), permissionsQuery.getParams());
        });
    }

    @Override
    public int deletePermissions(Integer permissionType, String targetId) {
        return (Integer)this.transactionTemplate.execute(() -> this.ao.deleteWithSQL(DHPermission.class, "PERMISSION = ? AND TARGET_ID = ?", new Object[]{permissionType, targetId}));
    }

    @Override
    public List<PermissionModel> createPermissions(List<PermissionModel> permissions) {
        return (List)this.transactionTemplate.execute(() -> permissions.stream().map(pModel -> {
            DHPermission newP = (DHPermission)this.ao.create(DHPermission.class, new DBParam[]{new DBParam("HOLDER_ID", (Object)pModel.getHolderId()), new DBParam("HOLDER_TYPE", (Object)pModel.getHolderType()), new DBParam("PERMISSION", (Object)pModel.getPermission()), new DBParam("TARGET_ID", (Object)pModel.getTargetId()), new DBParam("TARGET_TYPE", (Object)pModel.getTargetType())});
            newP.save();
            return newP;
        }).map(this::txDHPermission).collect(Collectors.toList()));
    }
}

