/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.migrations.v1_3_4;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.roninpixels.dashboardhub.ao.UserProperty;
import com.roninpixels.dashboardhub.controllers.DatasourcesController;
import com.roninpixels.dashboardhub.migrations.DHMigrationTask;
import com.roninpixels.dashboardhub.migrations.DHTaskPriority;
import com.roninpixels.dashboardhub.store.AddonPropertiesRepository;
import com.roninpixels.dashboardhub.store.DHDatasourcesRepository;
import com.roninpixels.dashboardhub.store.impl.UserPropertiesRepositoryImpl;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@DHTaskPriority(value=30)
public class DatasourcesFromControllerV1toV2
implements DHMigrationTask {
    private static final Logger log = LoggerFactory.getLogger(DatasourcesFromControllerV1toV2.class);
    private static final boolean DELETE_FROM_OLD_REPO = false;
    @Autowired
    @ComponentImport
    private ActiveObjects ao;
    @Autowired
    private AddonPropertiesRepository addonPropsRepo;
    @Autowired
    private UserPropertiesRepositoryImpl userPropsRepo;
    @Autowired
    private DatasourcesController oldDatasourceController;
    @Autowired
    private DHDatasourcesRepository dsRepo;
    @Autowired
    private Crypto dhCrypto;

    @Override
    public void execute() {
        try {
            this.migratePublicDatasources();
            this.migratePrivateDatasources();
        }
        catch (Exception e) {
            log.error("Problems migrating data sources to v1.3.4", (Throwable)e);
        }
    }

    private void migratePublicDatasources() throws IOException {
        boolean isPrivate = false;
        List<DatasourceModel> datasources = this.oldDatasourceController.getDatasources(false);
        for (DatasourceModel ds : datasources) {
            boolean isMigrated = this.isDatasourceMigrated(ds);
            if (!isMigrated) {
                try {
                    if (ds.getCreator() == null) {
                        ds.setCreator("dh-addon-system");
                    }
                    ds.setPrivate(false);
                    isMigrated = this.dsRepo.addDatasource(ds);
                }
                catch (Exception e) {
                    log.error(String.format("Problems migrating a datasource from v1 to v2: %s (%s)", ds.getName(), ds.getId()), (Throwable)e);
                }
            }
            if (!isMigrated) continue;
        }
    }

    private void migratePrivateDatasources() throws IOException {
        UserProperty[] props = (UserProperty[])this.ao.find(UserProperty.class, "KEY = ?", new Object[]{"datasources"});
        List users = Arrays.stream(props).map(prop -> prop.getUserKey()).collect(Collectors.toList());
        for (String userKey : users) {
            this.migrateUserPrivateDatasources(userKey);
        }
    }

    private void migrateUserPrivateDatasources(String userKey) throws IOException {
        boolean isPrivate = true;
        List<DatasourceModel> datasources = this.oldDatasourceController.getDatasources(userKey, true);
        for (DatasourceModel ds : datasources) {
            boolean isMigrated = this.isDatasourceMigrated(ds);
            if (!isMigrated) {
                try {
                    ds.setPrivate(true);
                    isMigrated = this.dsRepo.addDatasource(ds);
                }
                catch (Exception e) {
                    log.error(String.format("Problems migrating a private datasource from v1 to v2: %s (%s)", ds.getName(), ds.getId()), (Throwable)e);
                }
            }
            if (!isMigrated) continue;
        }
    }

    private boolean isDatasourceMigrated(DatasourceModel ds) {
        try {
            return this.dsRepo.getDatasource(ds.getId()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

