/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.opsgenie;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.opsgenie.OpsgenieGadgetRequesterBase;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class OpenAlerts
extends OpsgenieGadgetRequesterBase {
    private static final Logger log = LoggerFactory.getLogger(OpenAlerts.class);

    List getAlerts() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("query", "status: open");
        params.put("limit", "3");
        params.put("sort", "updatedAt");
        params.put("order", "desc");
        ResponseEntity<String> resp = this.connector.getAlerts(params);
        Map responseBody = this.checkStatusAndParse(resp, Map.class);
        return responseBody.getOrDefault("data", Collections.emptyList());
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("alerts", this.getAlerts());
            data.put("link", this.connector.getURL());
            return data;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

