/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.JSMBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.util.JSMDataUtil2;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.util.SLAAccomplishmentConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamQueue
extends JSMBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(TeamQueue.class);

    protected List getIssues(Map queue, String dateFrom) {
        String queueJql = (String)queue.get("jql");
        List fields = (List)queue.get("fields");
        String jql = String.format("updatedDate >= '%s' AND %s", dateFrom, queueJql);
        return this.execJQLwithFilterFields(jql, fields, null, null, null, null);
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        SLAAccomplishmentConfig config = GadgetRequesterUtils.getConfig(gadget, SLAAccomplishmentConfig.class);
        try {
            Map queue = this.getQueue(config.getProject(), config.getQueue());
            String dateFrom = JSMDataUtil2.getDateAsString(config.getTimeRange());
            List issues = this.getIssues(queue, dateFrom);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("issues", issues);
            data.put("queue", queue);
            return data;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems getting data", e);
        }
    }
}

