/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket;

import com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket.BitbucketGadgetRequesterBase;
import com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket.configBeans.GRWithReposConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class HallOfWidget
extends BitbucketGadgetRequesterBase {
    private static final Logger log = LoggerFactory.getLogger(HallOfWidget.class);
    private final Type mType;

    public HallOfWidget(Type hallOfType) {
        this.mType = hallOfType;
    }

    List<Map> getPipelines(List<String> repos) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pagelen", "40");
        params.put("sort", "-created_on");
        return repos.parallelStream().map(slug -> {
            ResponseEntity<List> res = this.connector.getPipelines((String)slug, (Map<String, String>)params);
            this.checkStatus(res);
            return (List)res.getBody();
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    List<Map> filterPipelines(List<Map> pipelines) {
        return pipelines.stream().filter(pl -> {
            Map state = (Map)pl.get("state");
            if (!state.containsKey("result")) {
                return false;
            }
            String resultType = (String)((Map)state.get("result")).get("type");
            return "pipeline_state_completed".equals(state.get("type")) && this.mType.state.equals(resultType);
        }).collect(Collectors.toList());
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        GRWithReposConfig config = GadgetRequesterUtils.getConfig(gadget, GRWithReposConfig.class);
        List<Map> pipelines = this.getPipelines(config.getRepositoriesSlugs());
        List<Map> filteredPipelines = this.filterPipelines(pipelines);
        List<Map> sortedPipelines = this.sortPipelines(filteredPipelines);
        HashMap<String, List<Map>> data = new HashMap<String, List<Map>>();
        data.put("pipelines", sortedPipelines);
        return data;
    }

    public static enum Type {
        HallOfFame("pipeline_state_completed_successful"),
        HallOfShame("pipeline_state_completed_failed");

        private final String state;

        private Type(String state) {
            this.state = state;
        }

        public String getState() {
            return this.state;
        }
    }
}

