/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers;

import com.roninpixels.dashboardhub.datasources.DatasourceGenerator;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.controllers.DatasourcesController;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.store.DHDatasourcesRepository;
import com.roninpixels.dashboardhub.utils.filter.FilterUtils;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.collections.ListUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DatasourcesControllerV2
implements DatasourcesController {
    private static final Logger log = LoggerFactory.getLogger(DatasourcesControllerV2.class);
    @Inject
    private DHUserService dhUserService;
    @Inject
    private DHDatasourcesRepository dsRepo;
    @Inject
    private DatasourceGenerator dsGenerator;
    private ObjectMapper mMapper = new ObjectMapper();

    @Inject
    public DatasourcesControllerV2() {
    }

    @Override
    public List<DatasourceModel> getDatasources(String userKey, Boolean isPrivate) throws IOException {
        return isPrivate != false ? this.dsRepo.getPrivateDatasources(userKey) : this.dsRepo.getGlobalDatasources();
    }

    AppUser getLoggedInUser(boolean throwExceptionIfNotLogged) {
        AppUser user = this.dhUserService.getLoggedInUser();
        if (throwExceptionIfNotLogged && user == null) {
            throw new IllegalArgumentException("Get private datasources without a logged user is not possible");
        }
        return user;
    }

    @Override
    public List<DatasourceModel> getDatasources(Boolean isPrivate) throws IOException {
        AppUser user = this.getLoggedInUser(isPrivate);
        return this.getDatasources(user == null ? null : user.getKey(), isPrivate);
    }

    @Override
    public DatasourceModel getDatasource(String id) throws IOException {
        return this.dsRepo.getDatasource(id);
    }

    @Override
    public DatasourceModel getDatasource(String id, Boolean isPrivate, String userKey) throws IOException {
        return this.dsRepo.getDatasource(id);
    }

    @Override
    public boolean addDatasource(DatasourceModel newDs, Boolean isPrivate) throws IOException {
        List<DatasourceModel> datasources = this.getDatasources(isPrivate);
        DatasourceModel actualNewDs = this.dsGenerator.generateDatasource(newDs, datasources);
        return this.dsRepo.addDatasource(actualNewDs);
    }

    @Override
    public DatasourceModel removeDatasource(String id, Boolean isPrivate) throws IOException {
        String userKey = this.dhUserService.getLoggedInUserKey();
        DatasourceModel ds = this.getDatasource(id);
        if (!this.dhUserService.isLoggedUserAdmin().booleanValue() && !ds.getCreator().equals(userKey)) {
            log.error("Problems with datasource: User not allowed to remove datasource.");
            throw new RuntimeException("User not allowed to remove datasource");
        }
        DatasourceModel removedDs = this.dsRepo.removeDatasource(id);
        return removedDs;
    }

    @Override
    public List<String> getFilterCompatDatasources() throws IOException {
        List allDatasources = ListUtils.union(this.dsRepo.getGlobalDatasources(), this.dsRepo.getPrivateDatasources());
        return FilterUtils.getDatasourceCompatIds(allDatasources);
    }
}

