/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.common.functions;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.globals.DefaultFilter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public abstract class ExecJQLFunc {
    private static final Logger log = LoggerFactory.getLogger(ExecJQLFunc.class);
    private final ServerConnector connector;
    private String path;

    public ExecJQLFunc(ServerConnector connector, String path) {
        this.connector = connector;
        this.path = path;
    }

    public boolean jqlIsAPredefinedFilter(String jql) {
        return jql.matches("filter\\s*=\\s*-[0-9]");
    }

    public Long getFilterId(String jql) {
        Pattern p = Pattern.compile("-[0-9]");
        Matcher m = p.matcher(jql);
        return m.find() ? Long.valueOf(Long.parseLong(m.group())) : null;
    }

    public String getJQLFromFilter(String originalJQL) {
        Long filterId = this.getFilterId(originalJQL);
        DefaultFilter filter = DefaultFilter.getById(filterId);
        return filter != null ? filter.getJql() : null;
    }

    public List exec(String jql, List<String> fields, List<String> expand, List<String> properties, Map<String, Object> extraOpts) {
        String actualJql = this.jqlIsAPredefinedFilter(jql) ? this.getJQLFromFilter(jql) : jql;
        HashMap<String, Object> mParams = extraOpts != null ? new HashMap<String, Object>(extraOpts) : new HashMap();
        boolean loadAll = mParams.containsKey("loadAll") ? (Boolean)mParams.remove("loadAll") : true;
        mParams.putIfAbsent("maxResults", 200);
        mParams.putIfAbsent("jql", actualJql);
        mParams.putIfAbsent("startAt", 0);
        if (fields != null) {
            mParams.putIfAbsent("fields", fields);
        }
        if (expand != null) {
            mParams.putIfAbsent("expand", expand);
        }
        if (properties != null) {
            mParams.putIfAbsent("properties", properties);
        }
        try {
            boolean moreIssues;
            LinkedList issues = new LinkedList();
            do {
                ResponseEntity<Map> response = this.connector.executeRequest(Request.MethodType.POST, this.path, mParams, Map.class);
                Map result = (Map)response.getBody();
                if (response.getStatusCode().value() >= 400) {
                    throw new BadRequestToSourceException(response);
                }
                int currentResultCount = 0;
                if (result.containsKey("issues")) {
                    List currentIssues = (List)result.get("issues");
                    issues.addAll(currentIssues);
                    currentResultCount = currentIssues.size();
                }
                int total = result.getOrDefault("total", 0);
                int startAt = result.getOrDefault("startAt", 0);
                moreIssues = issues.size() < total && loadAll && issues.size() < 1000;
                int next = startAt + currentResultCount;
                mParams.put("startAt", next);
            } while (moreIssues);
            return issues;
        }
        catch (BadRequestToSourceException bre) {
            throw bre;
        }
        catch (Exception ex) {
            log.error("Bad data", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

