/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.confluenceServer;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.impl.confluenceServer.functions.ExecCQLFunc;
import com.roninpixels.dashboardhub.connectors.impl.confluenceServer.functions.GetInlineTasksFunc;
import com.roninpixels.dashboardhub.connectors.impl.confluenceServer.functions.GetSpacesFunc;
import com.roninpixels.dashboardhub.connectors.impl.confluenceServer.functions.IsValidFunc;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.ConfluenceConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.ImageProvider;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ConfluenceRestConnector
implements ConfluenceConnector,
ImageProvider {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceRestConnector.class);
    public static final int MIN_VERSION = 7901;
    public static final String REST_API_USER_CURRENT = "/rest/api/user/current";
    public static final String REST_API_CONTENT_S = "/rest/api/content/%s";
    public static final String SERVER_INFO_PATH = "/rest/applinks/1.0/manifest";
    public static final String REST_API_USER_DETAIL = "/rest/api/user?username=%s";
    private ServerConnector connector;

    public ConfluenceRestConnector(ServerConnector connector) {
        this.connector = connector;
    }

    @Override
    public String getURL() {
        return this.connector.getURL();
    }

    @Override
    public boolean isValid() {
        log.debug("ISVALID FUNCT");
        return new IsValidFunc(this, this.connector).isValid();
    }

    @Override
    public ResponseEntity<List> getSpaces(Map params, Map options) {
        return new GetSpacesFunc(this.connector).getSpaces(params, options);
    }

    @Override
    public List execCQL(Map params, Map<String, Object> options) {
        return new ExecCQLFunc(this.connector).execCQL(params, options);
    }

    @Override
    public List getInlineTasks(Map params, Map options) throws IOException {
        return new GetInlineTasksFunc(this.connector).getData(params);
    }

    @Override
    public List getUsersByUsername(List<String> users) {
        return users.stream().map(username -> {
            String path = String.format(REST_API_USER_DETAIL, username);
            ResponseEntity<Map> responseEntity = this.connector.executeRequest(path, null, Map.class);
            return responseEntity.getStatusCode().value() < 400 ? (Map)responseEntity.getBody() : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public ResponseEntity<String> serverInfo() {
        return this.connector.executeRequest(SERVER_INFO_PATH);
    }

    @Override
    public ResponseEntity<String> me() {
        return this.connector.executeRequest(REST_API_USER_CURRENT);
    }

    @Override
    public Map getContent(Integer contentId) {
        String path = String.format(REST_API_CONTENT_S, contentId);
        ResponseEntity<Map> responseEntity = this.connector.executeRequest(path, null, Map.class);
        ResponseChecker.checkStatus(responseEntity);
        return (Map)responseEntity.getBody();
    }

    @Override
    public ResponseEntity<InputStream> getImage(String path) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "*/*".toString());
        headers.put("encoding", "binary");
        ResponseEntity<InputStream> response = this.connector.executeRequest(Request.MethodType.GET, path, null, headers, InputStream.class);
        return response;
    }
}

