/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.bigpicture;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.BigPictureConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.Map;
import org.springframework.http.ResponseEntity;

public class BigPictureConnectorServerImpl
implements BigPictureConnector {
    public static final String APP_SUBPATH = "/rest/softwareplant-bigpicture/1.0";
    public static final String PATH_AUTH = "/system/auth";
    public static final String PATH_LICENSE = "/multitenant/system/status";
    private final ServerConnector connector;
    private final JiraConnector jiraConnector;

    public BigPictureConnectorServerImpl(ServerConnector connector, JiraConnector jiraConnector) {
        this.connector = connector;
        this.jiraConnector = jiraConnector;
    }

    @Override
    public String getURL() {
        return this.connector.getURL();
    }

    @Override
    public JiraConnector getJiraConnector() {
        return this.jiraConnector;
    }

    @Override
    public boolean isValid() {
        try {
            Map authResp = this.auth();
            return authResp.containsKey("authentication");
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map auth() {
        ResponseEntity<Map> res = this.connector.executeRequest(PATH_AUTH, null, Map.class);
        ResponseChecker.checkStatus(res);
        return (Map)res.getBody();
    }

    public void sample_test() {
        ResponseEntity<Map> res = this.connector.executeRequest(PATH_LICENSE, null, Map.class);
        ResponseChecker.checkStatus(res);
    }
}

