/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.dashboardHub.dashboardfilters.filterRules;

import com.roninpixels.dashboardhub.confluence.dashboardfilters.controllers.DashboardFilterRulesController;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.web.models.DashboardFilterRule;
import com.roninpixels.dashboardhub.services.DHUserService;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/filterRules")
public class FilterRulesEndpoint {
    private static final Logger log = LoggerFactory.getLogger(FilterRulesEndpoint.class);
    @Inject
    private DashboardFilterRulesController dashboardFilterRulesController;
    @Inject
    private DHUserService dhUserService;

    @GET
    @Produces(value={"application/json"})
    public Response getFilterRules() {
        try {
            if (!this.dhUserService.isLoggedUserAdmin().booleanValue()) {
                return Response.status((int)403).build();
            }
            List<DashboardFilterRule> filterRules = this.dashboardFilterRulesController.getDashboardFilterRules();
            return Response.ok(filterRules).build();
        }
        catch (Exception e) {
            log.error("Problems getting all the filter rules", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/{key}")
    @Produces(value={"application/json"})
    public Response getFilterRuleByKey(@NotNull @PathParam(value="key") String key) {
        try {
            if (!this.dhUserService.isLoggedUserAdmin().booleanValue()) {
                return Response.status((int)403).build();
            }
            DashboardFilterRule filterRule = this.dashboardFilterRulesController.getDashboardFilterRule(key);
            return Response.ok((Object)filterRule).build();
        }
        catch (Exception e) {
            log.error("Problems getting the filter rule", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addFilterRule(DashboardFilterRule filterRule) {
        try {
            if (!this.dhUserService.isLoggedUserAdmin().booleanValue()) {
                return Response.status((int)403).build();
            }
            DashboardFilterRule filterRuleAdded = this.dashboardFilterRulesController.setDashboardFilterRule(filterRule);
            return this.getFilterRules();
        }
        catch (Exception e) {
            log.error("Problems adding the filter rule", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateFilterRules(DashboardFilterRule filterRule) {
        try {
            if (!this.dhUserService.isLoggedUserAdmin().booleanValue()) {
                return Response.status((int)403).build();
            }
            DashboardFilterRule filterRuleUpdated = this.dashboardFilterRulesController.setDashboardFilterRule(filterRule);
            return this.getFilterRules();
        }
        catch (Exception e) {
            log.error("Problems updating the filter rule", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @DELETE
    @Path(value="/{key}")
    @Produces(value={"application/json"})
    public Response removeFilterRules(@NotNull @PathParam(value="key") String key) {
        try {
            if (!this.dhUserService.isLoggedUserAdmin().booleanValue()) {
                return Response.status((int)403).build();
            }
            boolean removed = this.dashboardFilterRulesController.removeDashboardFilterRule(key);
            if (!removed) {
                log.error("Problems removing the filter rule");
                return Response.status((int)400).build();
            }
            return this.getFilterRules();
        }
        catch (Exception e) {
            log.error("Problems removing the filter rule", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

