/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.store.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Preconditions;
import com.roninpixels.dashboardhub.ao.DHBoardUserPreference;
import com.roninpixels.dashboardhub.store.DHBoardUserPreferencesRepository;
import com.roninpixels.dashboardhub.web.models.BoardUserPreferenceModel;
import java.io.IOException;
import java.util.Date;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DHBoardUserPreferencesRepositoryImpl
implements DHBoardUserPreferencesRepository {
    private static final Logger log = LoggerFactory.getLogger(DHBoardUserPreferencesRepositoryImpl.class);
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private final ObjectMapper mMapper;

    @Inject
    public DHBoardUserPreferencesRepositoryImpl(ActiveObjects ao, TransactionTemplate transactionTemplate) {
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
        this.transactionTemplate = transactionTemplate;
        this.mMapper = new ObjectMapper();
    }

    @Override
    public BoardUserPreferenceModel getBoardUserPreference(String userKey, String boardId) {
        DHBoardUserPreference dhBoardUserPreference = this.findBoardUserPreference(userKey, boardId);
        return dhBoardUserPreference != null ? this.txDHBoardUserPreference(dhBoardUserPreference) : null;
    }

    @Override
    public BoardUserPreferenceModel addBoardUserPreference(String userKey, String boardId, String filter) throws IOException {
        String filterValue = filter == null || filter.equals("") ? "{}" : filter;
        DHBoardUserPreference savedBoardUserPreference = (DHBoardUserPreference)this.transactionTemplate.execute(() -> {
            DHBoardUserPreference userPreference = (DHBoardUserPreference)this.ao.create(DHBoardUserPreference.class, new DBParam[]{new DBParam("USER_KEY", (Object)userKey), new DBParam("BOARD_ID", (Object)boardId), new DBParam("CREATED", (Object)new Date()), new DBParam("UPDATED", (Object)new Date()), new DBParam("FILTER", (Object)filterValue)});
            userPreference.save();
            log.debug("BoardUserPreference created -> " + userPreference.getUserKey() + " - " + userPreference.getBoardId());
            return userPreference;
        });
        return this.txDHBoardUserPreference(savedBoardUserPreference);
    }

    @Override
    public BoardUserPreferenceModel updateBoardUserPreference(String userKey, String boardId, String filter) {
        DHBoardUserPreference updatedBoardUserPreference = (DHBoardUserPreference)this.transactionTemplate.execute(() -> {
            DHBoardUserPreference target = this.findBoardUserPreference(userKey, boardId);
            if (target != null) {
                target.setFilter(filter);
                target.setUpdated(new Date());
                target.save();
                log.debug("BoardUserPreference updated -> " + userKey + " - " + boardId);
            }
            return target;
        });
        return updatedBoardUserPreference != null ? this.txDHBoardUserPreference(updatedBoardUserPreference) : null;
    }

    @Override
    public int removeBoardUserPreferenceByBoard(String boardId) {
        return (Integer)this.transactionTemplate.execute(() -> this.ao.deleteWithSQL(DHBoardUserPreference.class, "BOARD_ID = ?", new Object[]{boardId}));
    }

    private DHBoardUserPreference findBoardUserPreference(String userKey, String boardId) {
        Query query = Query.select().where("USER_KEY = ? AND BOARD_ID = ?", new Object[]{userKey, boardId});
        DHBoardUserPreference[] boardUserPreferences = (DHBoardUserPreference[])this.ao.find(DHBoardUserPreference.class, query);
        if (boardUserPreferences.length == 0) {
            return null;
        }
        if (boardUserPreferences.length > 1) {
            throw new RuntimeException(String.format("There are more than one boardUserPreference with same userKey: %s - boardId: %s", userKey, boardId));
        }
        return boardUserPreferences[0];
    }

    private BoardUserPreferenceModel txDHBoardUserPreference(DHBoardUserPreference boardUserPreference) {
        BoardUserPreferenceModel model = new BoardUserPreferenceModel();
        model.setId(boardUserPreference.getID());
        model.setUserKey(boardUserPreference.getUserKey());
        model.setBoardId(boardUserPreference.getBoardId());
        model.setCreated(boardUserPreference.getCreated());
        model.setUpdated(boardUserPreference.getUpdated());
        model.setFilter(boardUserPreference.getFilter());
        return model;
    }
}

