/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.license;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.roninpixels.dashboardhub.license.LicenseInfoJsonBean;
import com.roninpixels.dashboardhub.license.LicenseStatusJsonBean;
import com.roninpixels.dashboardhub.services.ApplicationPropertiesAccesor;
import com.roninpixels.dashboardhub.services.DashboardHubPluginManager;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DashboardHubPluginManagerImpl
implements DashboardHubPluginManager {
    private static final Logger log = LoggerFactory.getLogger(DashboardHubPluginManagerImpl.class);
    private static final String TK_DEV_MODE = "ronin.dev.mode";
    @ComponentImport
    private final PluginLicenseManager licenseManager;
    @ComponentImport
    private final PluginAccessor pluginAccessor;
    @Inject
    private ApplicationPropertiesAccesor applicationProperties;

    @Inject
    public DashboardHubPluginManagerImpl(PluginAccessor pluginAccessor, PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
        this.pluginAccessor = pluginAccessor;
        this.applicationProperties = this.applicationProperties;
    }

    @Override
    public boolean isLicensed() {
        LicenseStatusJsonBean bean = this.getLicenseStatus();
        return bean != null && bean.isValid();
    }

    @Override
    public LicenseStatusJsonBean getLicenseStatus() {
        LicenseStatusJsonBean bean;
        if (this.licenseManager.getLicense().isDefined()) {
            bean.setValid((bean = LicenseStatusJsonBean.shortBean((PluginLicense)this.licenseManager.getLicense().get())).isValid() || this.isDevModeEnabled());
        } else {
            bean = this.getDataForNoPresentLicense();
        }
        return bean;
    }

    @Override
    public String getPluginVersion() {
        String key = this.licenseManager.getPluginKey();
        return this.pluginAccessor.getEnabledPlugin(key).getPluginInformation().getVersion();
    }

    @Override
    public boolean isDevModeEnabled() {
        String debugPropValue = this.applicationProperties.getSystemProperty(TK_DEV_MODE, "false");
        return Boolean.parseBoolean(debugPropValue);
    }

    @Override
    public String getDataService() {
        return "lfdzB5ajxaS".replaceAll("a", "e");
    }

    @Override
    public LicenseInfoJsonBean getLicenseDetails(String pluginKey) {
        if (!this.licenseManager.getPluginKey().equals(pluginKey)) {
            return null;
        }
        return LicenseInfoJsonBean.shortBean(this.pluginAccessor.getPlugin(pluginKey), (PluginLicense)this.licenseManager.getLicense().getOrElse((Object)null), this.applicationProperties.getDisplayName());
    }

    private LicenseStatusJsonBean getDataForNoPresentLicense() {
        String key = this.licenseManager.getPluginKey();
        LicenseStatusJsonBean bean = new LicenseStatusJsonBean();
        bean.setValid(this.isDevModeEnabled());
        bean.setKey(key);
        return bean;
    }
}

