/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.common.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public abstract class GetJqlSuggestions {
    private static final Logger log = LoggerFactory.getLogger(GetJqlSuggestions.class);
    private final ServerConnector connector;
    private String path;

    public GetJqlSuggestions(ServerConnector jiraServerConnector, String path) {
        this.connector = jiraServerConnector;
        this.path = path;
    }

    public ResponseEntity<String> getJqlSuggestions(Map<String, ?> params) {
        ResponseEntity<String> response = this.connector.executeRequest(this.path, params);
        if (response.getStatusCode().value() >= 400) {
            return response;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map responseData = (Map)mapper.readValue((String)response.getBody(), Map.class);
            return new ResponseEntity((Object)mapper.writeValueAsString(responseData.get("results")), response.getStatusCode());
        }
        catch (IOException ioe) {
            log.error("Internal problems with autocompletedata suggestions", (Throwable)ioe);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

