/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.factories;

import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.DatasourceBasicAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.connectors.factories.ConnectorFactory;
import com.roninpixels.dashboardhub.connectors.impl.dilbert.DilbertConnectorImpl;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.DilbertConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.RestAuthStrategyFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.ServerConnectorFactory;
import com.roninpixels.dashboardhub.datasources.DatasourceGenerator;
import com.roninpixels.dashboardhub.globals.Product;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.util.Collections;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Lazy
@Component
public class DilbertConnectorFactory
implements ConnectorFactory {
    private static final Logger log = LoggerFactory.getLogger(DilbertConnectorFactory.class);
    @Inject
    private ServerConnectorFactory serverConnectorFactory;
    @Inject
    private RestAuthStrategyFactory authStrategyFactory;
    @Inject
    private DatasourceGenerator dsGenerator;
    private DatasourceModel singletonDs;

    @EventListener
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.singletonDs == null) {
            DatasourceModel seed = new DatasourceModel();
            seed.setProduct(Product.DILBERT.value());
            this.singletonDs = this.dsGenerator.generateDatasource(seed, Collections.emptyList());
        }
    }

    @Override
    public DHConnector createConnector(DatasourceModel ds) {
        RestAuthStrategy strategy = this.authStrategyFactory.getRestAuthStrategy(DatasourceBasicAuthStrategy.class, this.singletonDs);
        ServerConnector connector = this.serverConnectorFactory.getServerConnector(this.singletonDs, strategy);
        return new DilbertConnectorImpl(connector);
    }

    @Override
    public boolean match(DatasourceModel ds) {
        return ds.getProduct().equals(DilbertConnector.PRODUCT);
    }
}

