/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.jira.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.web.rest.jira.api.GenericJiraEndpoint;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/jira/v1/queues")
public class QueuesEndpoint {
    private static final Logger log = LoggerFactory.getLogger(QueuesEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;
    @Inject
    private DHUserService dhUserService;

    @GET
    @AnonymousAllowed
    @Path(value="/{serviceDeskId}")
    @Produces(value={"application/json"})
    public Response jqlProxy(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @NotNull @PathParam(value="serviceDeskId") String serviceDeskId, @Context UriInfo ui) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            MultivaluedMap params = ui.getQueryParameters();
            ResponseEntity<List> response = jira.getQueues(serviceDeskId, (Map<String, ?>)params);
            return GenericJiraEndpoint.generateResponse(response);
        }
        catch (Exception e) {
            log.error("Problems getting queues for serviceDeskId: " + serviceDeskId, (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

